/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.ClusterDescription;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.ServerDescription;
import com.mongodb.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaggableReadPreference
extends ReadPreference {
    private static final List<DBObject> EMPTY = new ArrayList<DBObject>();
    final List<DBObject> _tags;

    TaggableReadPreference() {
        this._tags = EMPTY;
    }

    TaggableReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
        if (firstTagSet == null) {
            throw new IllegalArgumentException("Must have at least one tag set");
        }
        this._tags = new ArrayList<DBObject>();
        this._tags.add(firstTagSet);
        Collections.addAll(this._tags, remainingTagSets);
    }

    @Override
    public boolean isSlaveOk() {
        return true;
    }

    @Override
    public DBObject toDBObject() {
        BasicDBObject readPrefObject = new BasicDBObject("mode", this.getName());
        if (!this._tags.isEmpty()) {
            readPrefObject.put("tags", (Object)this._tags);
        }
        return readPrefObject;
    }

    public List<DBObject> getTagSets() {
        ArrayList<DBObject> tags = new ArrayList<DBObject>();
        for (DBObject tagSet : this._tags) {
            tags.add(tagSet);
        }
        return tags;
    }

    public String toString() {
        return this.getName() + this.printTags();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggableReadPreference that = (TaggableReadPreference)o;
        return this._tags.equals(that._tags);
    }

    public int hashCode() {
        int result = this._tags.hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    @Override
    List<ServerDescription> choose(ClusterDescription clusterDescription) {
        if (this._tags.isEmpty()) {
            return this.getServers(clusterDescription);
        }
        for (DBObject curTagSet : this._tags) {
            Tags tags = TaggableReadPreference.getTagsFromDBObject(curTagSet);
            List<ServerDescription> taggedServers = this.getServersForTags(clusterDescription, tags);
            if (taggedServers.isEmpty()) continue;
            return taggedServers;
        }
        return Collections.emptyList();
    }

    abstract List<ServerDescription> getServers(ClusterDescription var1);

    abstract List<ServerDescription> getServersForTags(ClusterDescription var1, Tags var2);

    String printTags() {
        return this._tags.isEmpty() ? "" : " : " + new BasicDBObject("tags", this._tags);
    }

    private static Tags getTagsFromDBObject(DBObject curTagSet) {
        Tags tags = new Tags();
        for (String key : curTagSet.keySet()) {
            tags.append(key, curTagSet.get(key).toString());
        }
        return tags;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrimaryPreferredReadPreference
    extends SecondaryReadPreference {
        PrimaryPreferredReadPreference() {
        }

        PrimaryPreferredReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
            super(firstTagSet, remainingTagSets);
        }

        @Override
        public String getName() {
            return "primaryPreferred";
        }

        @Override
        List<ServerDescription> choose(ClusterDescription clusterDescription) {
            List<ServerDescription> servers = clusterDescription.getPrimaries();
            return !servers.isEmpty() ? servers : super.choose(clusterDescription);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NearestReadPreference
    extends TaggableReadPreference {
        NearestReadPreference() {
        }

        NearestReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
            super(firstTagSet, remainingTagSets);
        }

        @Override
        public String getName() {
            return "nearest";
        }

        @Override
        List<ServerDescription> getServers(ClusterDescription clusterDescription) {
            return clusterDescription.getAnyPrimaryOrSecondary();
        }

        @Override
        List<ServerDescription> getServersForTags(ClusterDescription clusterDescription, Tags tags) {
            return clusterDescription.getAnyPrimaryOrSecondary(tags);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SecondaryPreferredReadPreference
    extends SecondaryReadPreference {
        SecondaryPreferredReadPreference() {
        }

        SecondaryPreferredReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
            super(firstTagSet, remainingTagSets);
        }

        @Override
        public String getName() {
            return "secondaryPreferred";
        }

        @Override
        List<ServerDescription> choose(ClusterDescription clusterDescription) {
            List<ServerDescription> servers = super.choose(clusterDescription);
            return !servers.isEmpty() ? servers : clusterDescription.getPrimaries();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SecondaryReadPreference
    extends TaggableReadPreference {
        SecondaryReadPreference() {
        }

        SecondaryReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
            super(firstTagSet, remainingTagSets);
        }

        @Override
        public String getName() {
            return "secondary";
        }

        @Override
        List<ServerDescription> getServers(ClusterDescription clusterDescription) {
            return clusterDescription.getSecondaries();
        }

        @Override
        List<ServerDescription> getServersForTags(ClusterDescription clusterDescription, Tags tags) {
            return clusterDescription.getSecondaries(tags);
        }
    }
}

