/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.MemoryBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkManagerImpl;
import org.nuxeo.ecm.core.work.WorkQueueDescriptorRegistry;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;

public class MemoryWorkQueuing
implements WorkQueuing {
    private static final Log log = LogFactory.getLog(MemoryWorkQueuing.class);
    protected final WorkManagerImpl mgr;
    protected final WorkQueueDescriptorRegistry workQueueDescriptors;
    protected final Map<String, BlockingQueue<Runnable>> allScheduled = new HashMap<String, BlockingQueue<Runnable>>();
    protected final Map<String, Map<String, Work>> allRunning = new HashMap<String, Map<String, Work>>();
    protected final Map<String, Map<String, Work>> allCompleted = new HashMap<String, Map<String, Work>>();

    public MemoryWorkQueuing(WorkManagerImpl mgr, WorkQueueDescriptorRegistry workQueueDescriptors) {
        this.mgr = mgr;
        this.workQueueDescriptors = workQueueDescriptors;
    }

    @Override
    public synchronized void init() {
        this.allScheduled.clear();
        this.allRunning.clear();
        this.allCompleted.clear();
    }

    protected WorkQueueDescriptor getDescriptor(String queueId) {
        WorkQueueDescriptor descriptor = this.workQueueDescriptors.get(queueId);
        if (descriptor == null) {
            throw new IllegalArgumentException("No such work queue: " + queueId);
        }
        return descriptor;
    }

    @Override
    public synchronized BlockingQueue<Runnable> getScheduledQueue(String queueId) {
        BlockingQueue<Runnable> scheduled = this.allScheduled.get(queueId);
        if (scheduled == null) {
            scheduled = this.newBlockingQueue(this.getDescriptor(queueId));
            this.allScheduled.put(queueId, scheduled);
        }
        return scheduled;
    }

    protected Map<String, Work> getRunning(String queueId) {
        Map<String, Work> running = this.allRunning.get(queueId);
        if (running == null) {
            running = this.newRunningMap();
            this.allRunning.put(queueId, running);
        }
        return running;
    }

    protected Map<String, Work> getCompleted(String queueId) {
        Map<String, Work> completed = this.allCompleted.get(queueId);
        if (completed == null) {
            completed = this.newCompletedMap();
            this.allCompleted.put(queueId, completed);
        }
        return completed;
    }

    protected BlockingQueue<Runnable> newBlockingQueue(WorkQueueDescriptor workQueueDescriptor) {
        int capacity;
        if (workQueueDescriptor.usePriority) {
            log.warn((Object)"Priority queues are now deprecated and function as regular queues");
        }
        if ((capacity = workQueueDescriptor.capacity) <= 0) {
            capacity = -1;
        }
        return new MemoryBlockingQueue(this, capacity);
    }

    protected Map<String, Work> newRunningMap() {
        return new HashMap<String, Work>();
    }

    protected Map<String, Work> newCompletedMap() {
        return new LinkedHashMap<String, Work>();
    }

    @Override
    public synchronized void workRunning(String queueId, Work work) {
        this.getRunning(queueId).put(work.getId(), work);
    }

    @Override
    public synchronized void workCompleted(String queueId, Work work) {
        this.getRunning(queueId).remove(work.getId());
        this.getCompleted(queueId).put(work.getId(), work);
    }

    @Override
    public Work find(String workId, Work.State state) {
        if (state == null) {
            Work w = this.findScheduled(workId);
            if (w == null) {
                w = this.findRunning(workId);
            }
            return w;
        }
        switch (state) {
            case SCHEDULED: {
                return this.findScheduled(workId);
            }
            case RUNNING: {
                return this.findRunning(workId);
            }
            case COMPLETED: {
                return this.findCompleted(workId);
            }
        }
        return null;
    }

    @Override
    public boolean isWorkInState(String workId, Work.State state) {
        if (state == null) {
            return this.isScheduled(workId) || this.isRunning(workId);
        }
        switch (state) {
            case SCHEDULED: {
                return this.isScheduled(workId);
            }
            case RUNNING: {
                return this.isRunning(workId);
            }
            case COMPLETED: {
                return this.isCompleted(workId);
            }
        }
        return false;
    }

    @Override
    public Work.State getWorkState(String workId) {
        if (this.findScheduled(workId) != null) {
            return Work.State.SCHEDULED;
        }
        if (this.isRunning(workId)) {
            return Work.State.RUNNING;
        }
        if (this.isCompleted(workId)) {
            return Work.State.COMPLETED;
        }
        return null;
    }

    @Override
    public synchronized List<Work> listWork(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.listScheduled(queueId);
            }
            case RUNNING: {
                return this.listRunning(queueId);
            }
            case COMPLETED: {
                return this.listCompleted(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public synchronized List<String> listWorkIds(String queueId, Work.State state) {
        if (state == null) {
            return this.listNonCompletedIds(queueId);
        }
        switch (state) {
            case SCHEDULED: {
                return this.listScheduledIds(queueId);
            }
            case RUNNING: {
                return this.listRunningIds(queueId);
            }
            case COMPLETED: {
                return this.listCompletedIds(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public int getQueueSize(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.getScheduledSize(queueId);
            }
            case RUNNING: {
                return this.getRunningSize(queueId);
            }
            case COMPLETED: {
                return this.getCompletedSize(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    protected synchronized int getScheduledSize(String queueId) {
        BlockingQueue<Runnable> scheduled = this.allScheduled.get(queueId);
        return scheduled == null ? 0 : scheduled.size();
    }

    protected synchronized int getRunningSize(String queueId) {
        Map<String, Work> running = this.allRunning.get(queueId);
        return running == null ? 0 : running.size();
    }

    protected synchronized int getCompletedSize(String queueId) {
        Map<String, Work> completed = this.allCompleted.get(queueId);
        return completed == null ? 0 : completed.size();
    }

    protected synchronized boolean isScheduled(String workId) {
        for (BlockingQueue<Runnable> scheduled : this.allScheduled.values()) {
            MemoryBlockingQueue q = (MemoryBlockingQueue)scheduled;
            if (!q.containsWorkId(workId)) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean isRunning(String workId) {
        for (Map<String, Work> running : this.allRunning.values()) {
            if (!running.containsKey(workId)) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean isCompleted(String workId) {
        for (Map<String, Work> completed : this.allCompleted.values()) {
            if (!completed.containsKey(workId)) continue;
            return true;
        }
        return false;
    }

    protected synchronized Work findScheduled(String workId) {
        for (BlockingQueue<Runnable> scheduled : this.allScheduled.values()) {
            for (Runnable r : scheduled) {
                Work w = WorkHolder.getWork(r);
                if (!w.getId().equals(workId)) continue;
                return w;
            }
        }
        return null;
    }

    protected synchronized Work findRunning(String workId) {
        for (Map<String, Work> running : this.allRunning.values()) {
            Work w = running.get(workId);
            if (w == null) continue;
            return w;
        }
        return null;
    }

    protected synchronized Work findCompleted(String workId) {
        for (Map<String, Work> completed : this.allCompleted.values()) {
            Work w = completed.get(workId);
            if (w == null) continue;
            return w;
        }
        return null;
    }

    protected List<Work> listScheduled(String queueId) {
        BlockingQueue<Runnable> scheduled = this.getScheduledQueue(queueId);
        ArrayList<Work> list = new ArrayList<Work>(scheduled.size());
        for (Runnable r : scheduled) {
            Work w = WorkHolder.getWork(r);
            list.add(w);
        }
        return list;
    }

    protected List<Work> listRunning(String queueId) {
        return new ArrayList<Work>(this.getRunning(queueId).values());
    }

    protected List<Work> listCompleted(String queueId) {
        return new ArrayList<Work>(this.getCompleted(queueId).values());
    }

    protected List<String> listScheduledIds(String queueId) {
        BlockingQueue<Runnable> scheduled = this.getScheduledQueue(queueId);
        ArrayList<String> list = new ArrayList<String>(scheduled.size());
        for (Runnable r : scheduled) {
            Work w = WorkHolder.getWork(r);
            list.add(w.getId());
        }
        return list;
    }

    protected List<String> listRunningIds(String queueId) {
        return new ArrayList<String>(this.getRunning(queueId).keySet());
    }

    protected List<String> listNonCompletedIds(String queueId) {
        List<String> list = this.listScheduledIds(queueId);
        list.addAll(this.listRunningIds(queueId));
        return list;
    }

    protected List<String> listCompletedIds(String queueId) {
        return new ArrayList<String>(this.getCompleted(queueId).keySet());
    }

    @Override
    public Work removeScheduled(String queueId, String workId) {
        Iterator it = this.getScheduledQueue(queueId).iterator();
        while (it.hasNext()) {
            Runnable r = (Runnable)it.next();
            Work w = WorkHolder.getWork(r);
            if (!w.getId().equals(workId)) continue;
            it.remove();
            return w;
        }
        return null;
    }

    @Override
    public int setSuspending(String queueId) {
        ArrayList scheduled = new ArrayList();
        this.getScheduledQueue(queueId).drainTo(scheduled);
        for (Runnable r : scheduled) {
            Work work = WorkHolder.getWork(r);
            work.setWorkInstanceState(Work.State.CANCELED);
        }
        return scheduled.size();
    }

    @Override
    public Set<String> getCompletedQueueIds() {
        return new HashSet<String>(this.allCompleted.keySet());
    }

    @Override
    public synchronized void clearCompletedWork(String queueId, long completionTime) {
        Map<String, Work> completed = this.getCompleted(queueId);
        if (completionTime <= 0L) {
            completed.clear();
        } else {
            Iterator<Work> it = completed.values().iterator();
            while (it.hasNext()) {
                Work w = it.next();
                if (w.getCompletionTime() >= completionTime) continue;
                it.remove();
            }
        }
    }
}

