/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyUsage
implements Comparable<KeyUsage> {
    public static final KeyUsage NUMBER1 = new KeyUsage(1, "AS-REQ PA-ENC-TIMESTAMP padata timestamp, encrypted with the client key");
    public static final KeyUsage NUMBER2 = new KeyUsage(2, "AS-REP Ticket and TGS-REP Ticket (includes TGS session key or application session key), encrypted with the service key");
    public static final KeyUsage NUMBER3 = new KeyUsage(3, "AS-REP encrypted part (includes TGS session key or application session key), encrypted with the client key");
    public static final KeyUsage NUMBER4 = new KeyUsage(4, "TGS-REQ KDC-REQ-BODY AuthorizationData, encrypted with the TGS session key");
    public static final KeyUsage NUMBER5 = new KeyUsage(5, "TGS-REQ KDC-REQ-BODY AuthorizationData, encrypted with the TGS authenticator subkey");
    public static final KeyUsage NUMBER6 = new KeyUsage(6, "TGS-REQ PA-TGS-REQ padata AP-REQ Authenticator cksum, keyed with the TGS session key");
    public static final KeyUsage NUMBER7 = new KeyUsage(7, "TGS-REQ PA-TGS-REQ padata AP-REQ Authenticator (includes TGS authenticator subkey), encrypted with the TGS session key");
    public static final KeyUsage NUMBER8 = new KeyUsage(8, "TGS-REP encrypted part (includes application session key), encrypted with the TGS session key");
    public static final KeyUsage NUMBER9 = new KeyUsage(9, "TGS-REP encrypted part (includes application session key), encrypted with the TGS authenticator subkey");
    public static final KeyUsage NUMBER10 = new KeyUsage(10, "AP-REQ Authenticator cksum, keyed with the application session key");
    public static final KeyUsage NUMBER11 = new KeyUsage(11, "AP-REQ Authenticator (includes application authenticator subkey), encrypted with the application session key");
    public static final KeyUsage NUMBER12 = new KeyUsage(12, "AP-REP encrypted part (includes application session subkey), encrypted with the application session key");
    public static final KeyUsage NUMBER13 = new KeyUsage(13, "KRB-PRIV encrypted part, encrypted with a key chosen by the application");
    private static final KeyUsage[] values = new KeyUsage[]{NUMBER1, NUMBER2, NUMBER3, NUMBER4, NUMBER5, NUMBER6, NUMBER7, NUMBER8, NUMBER9, NUMBER10, NUMBER11, NUMBER12, NUMBER13};
    public static final List<KeyUsage> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final int ordinal;
    private final String name;

    private KeyUsage(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static KeyUsage getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (KeyUsage.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NUMBER1;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(KeyUsage that) {
        return this.ordinal - that.ordinal;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }
}

