/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.kerberos.shared.messages.MessageType;
import org.apache.directory.server.kerberos.shared.messages.components.EncKdcRepPart;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequest;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationData;
import org.apache.directory.server.kerberos.shared.messages.value.TicketFlags;

public class KdcReply
extends KerberosMessage
implements Encodable {
    private PreAuthenticationData[] paData;
    private KerberosPrincipal clientPrincipal;
    private Ticket ticket;
    private EncKdcRepPart encKDCRepPart = new EncKdcRepPart();
    private EncryptedData encPart;

    public KdcReply(MessageType msgType) {
        super(msgType);
    }

    public KdcReply(PreAuthenticationData[] paData, KerberosPrincipal clientPrincipal, Ticket ticket, EncryptedData encPart, MessageType msgType) {
        this(msgType);
        this.paData = paData;
        this.clientPrincipal = clientPrincipal;
        this.ticket = ticket;
        this.encPart = encPart;
    }

    public KerberosPrincipal getClientPrincipal() {
        return this.clientPrincipal;
    }

    public String getClientRealm() {
        return this.clientPrincipal.getRealm();
    }

    public EncryptedData getEncPart() {
        return this.encPart;
    }

    public PreAuthenticationData[] getPaData() {
        return this.paData;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setClientPrincipal(KerberosPrincipal clientPrincipal) {
        this.clientPrincipal = clientPrincipal;
    }

    public void setEncKDCRepPart(EncKdcRepPart repPart) {
        this.encKDCRepPart = repPart;
    }

    public void setEncPart(EncryptedData part) {
        this.encPart = part;
    }

    public void setPaData(PreAuthenticationData[] data) {
        this.paData = data;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public KerberosTime getAuthTime() {
        return this.encKDCRepPart.getAuthTime();
    }

    public HostAddresses getClientAddresses() {
        return this.encKDCRepPart.getClientAddresses();
    }

    public KerberosTime getEndTime() {
        return this.encKDCRepPart.getEndTime();
    }

    public TicketFlags getFlags() {
        return this.encKDCRepPart.getFlags();
    }

    public EncryptionKey getKey() {
        return this.encKDCRepPart.getKey();
    }

    public KerberosTime getKeyExpiration() {
        return this.encKDCRepPart.getKeyExpiration();
    }

    public LastRequest getLastRequest() {
        return this.encKDCRepPart.getLastRequest();
    }

    public int getNonce() {
        return this.encKDCRepPart.getNonce();
    }

    public KerberosTime getRenewTill() {
        return this.encKDCRepPart.getRenewTill();
    }

    public KerberosPrincipal getServerPrincipal() {
        return this.encKDCRepPart.getServerPrincipal();
    }

    public String getServerRealm() {
        return this.encKDCRepPart.getServerRealm();
    }

    public KerberosTime getStartTime() {
        return this.encKDCRepPart.getStartTime();
    }

    public void setAuthTime(KerberosTime time) {
        this.encKDCRepPart.setAuthTime(time);
    }

    public void setClientAddresses(HostAddresses addresses) {
        this.encKDCRepPart.setClientAddresses(addresses);
    }

    public void setEndTime(KerberosTime time) {
        this.encKDCRepPart.setEndTime(time);
    }

    public void setFlags(TicketFlags flags) {
        this.encKDCRepPart.setFlags(flags);
    }

    public void setKey(EncryptionKey key) {
        this.encKDCRepPart.setKey(key);
    }

    public void setKeyExpiration(KerberosTime expiration) {
        this.encKDCRepPart.setKeyExpiration(expiration);
    }

    public void setLastRequest(LastRequest request) {
        this.encKDCRepPart.setLastRequest(request);
    }

    public void setNonce(int nonce) {
        this.encKDCRepPart.setNonce(nonce);
    }

    public void setRenewTill(KerberosTime till) {
        this.encKDCRepPart.setRenewTill(till);
    }

    public void setServerPrincipal(KerberosPrincipal principal) {
        this.encKDCRepPart.setServerPrincipal(principal);
    }

    public void setStartTime(KerberosTime time) {
        this.encKDCRepPart.setStartTime(time);
    }
}

