/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.components;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosPrincipalModifier;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;
import org.apache.directory.server.kerberos.shared.messages.value.TicketFlags;
import org.apache.directory.server.kerberos.shared.messages.value.TransitedEncoding;

public class EncTicketPartModifier {
    private TicketFlags flags = new TicketFlags();
    private EncryptionKey sessionKey;
    private KerberosPrincipalModifier modifier = new KerberosPrincipalModifier();
    private KerberosPrincipal clientPrincipal;
    private TransitedEncoding transitedEncoding;
    private KerberosTime authTime;
    private KerberosTime startTime;
    private KerberosTime endTime;
    private KerberosTime renewTill;
    private HostAddresses clientAddresses;
    private AuthorizationData authorizationData;

    public EncTicketPart getEncTicketPart() {
        if (this.clientPrincipal == null) {
            this.clientPrincipal = this.modifier.getKerberosPrincipal();
        }
        return new EncTicketPart(this.flags, this.sessionKey, this.clientPrincipal, this.transitedEncoding, this.authTime, this.startTime, this.endTime, this.renewTill, this.clientAddresses, this.authorizationData);
    }

    public void setClientName(PrincipalName name) {
        this.modifier.setPrincipalName(name);
    }

    public void setClientRealm(String realm) {
        this.modifier.setRealm(realm);
    }

    public void setClientPrincipal(KerberosPrincipal clientPrincipal) {
        this.clientPrincipal = clientPrincipal;
    }

    public void setAuthorizationData(AuthorizationData data) {
        this.authorizationData = data;
    }

    public void setAuthTime(KerberosTime authtime) {
        this.authTime = authtime;
    }

    public void setClientAddresses(HostAddresses addresses) {
        this.clientAddresses = addresses;
    }

    public void setEndTime(KerberosTime time) {
        this.endTime = time;
    }

    public void setFlags(TicketFlags flags) {
        this.flags = flags;
    }

    public void setFlag(int flag) {
        this.flags.set(flag);
    }

    public void clearFlag(int flag) {
        this.flags.clear(flag);
    }

    public void setRenewTill(KerberosTime till) {
        this.renewTill = till;
    }

    public void setSessionKey(EncryptionKey key) {
        this.sessionKey = key;
    }

    public void setStartTime(KerberosTime time) {
        this.startTime = time;
    }

    public void setTransitedEncoding(TransitedEncoding encoding) {
        this.transitedEncoding = encoding;
    }
}

