/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.service;

import java.net.InetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.MessageType;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.mina.handler.chain.IoHandlerCommand;

public abstract class VerifyAuthHeader
implements IoHandlerCommand {
    private String contextKey = "context";

    public Authenticator verifyAuthHeader(ApplicationRequest authHeader, Ticket ticket, EncryptionKey serverKey, long clockSkew, ReplayCache replayCache, boolean emptyAddressesAllowed, InetAddress clientAddress, CipherTextHandler lockBox, KeyUsage authenticatorKeyUsage, boolean isValidate) throws KerberosException {
        KerberosTime now;
        int clientMicroSeconds;
        KerberosTime clientTime;
        KerberosPrincipal clientPrincipal;
        if (authHeader.getProtocolVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        if (authHeader.getMessageType() != MessageType.KRB_AP_REQ) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
        }
        if (authHeader.getTicket().getVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        EncryptionKey ticketKey = null;
        ticketKey = authHeader.getOption(1) ? authHeader.getTicket().getSessionKey() : serverKey;
        if (ticketKey == null) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOKEY);
        }
        EncTicketPart encPart = (EncTicketPart)lockBox.unseal(EncTicketPart.class, ticketKey, ticket.getEncPart(), KeyUsage.NUMBER2);
        ticket.setEncTicketPart(encPart);
        Authenticator authenticator = (Authenticator)lockBox.unseal(Authenticator.class, ticket.getSessionKey(), authHeader.getEncPart(), authenticatorKeyUsage);
        if (!authenticator.getClientPrincipal().getName().equals(ticket.getClientPrincipal().getName())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADMATCH);
        }
        if (ticket.getClientAddresses() != null ? !ticket.getClientAddresses().contains(new HostAddress(clientAddress)) : !emptyAddressesAllowed) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADADDR);
        }
        KerberosPrincipal serverPrincipal = ticket.getServerPrincipal();
        if (replayCache.isReplay(serverPrincipal, clientPrincipal = authenticator.getClientPrincipal(), clientTime = authenticator.getClientTime(), clientMicroSeconds = authenticator.getClientMicroSecond())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_REPEAT);
        }
        replayCache.save(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds);
        if (!authenticator.getClientTime().isInClockSkew(clockSkew)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_SKEW);
        }
        KerberosTime startTime = ticket.getStartTime() != null ? ticket.getStartTime() : ticket.getAuthTime();
        boolean isValidStartTime = startTime.lessThan(now = new KerberosTime());
        if (!isValidStartTime || ticket.getFlag(7) && !isValidate) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
        }
        if (!ticket.getEndTime().greaterThan(now)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
        }
        authHeader.setOption(2);
        return authenticator;
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

