/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.store.KerberosCatalog;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.AddPrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.ChangePassword;
import org.apache.directory.server.kerberos.shared.store.operations.DeletePrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.GetAllPrincipals;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.server.protocol.shared.catalog.Catalog;
import org.apache.directory.server.protocol.shared.catalog.GetCatalog;
import org.apache.directory.server.protocol.shared.store.ContextOperation;

class MultiBaseSearch
implements PrincipalStore {
    private InitialContextFactory factory;
    private Hashtable<String, Object> env = new Hashtable();
    private Catalog catalog;

    MultiBaseSearch(ServiceConfiguration config, InitialContextFactory factory) {
        this.factory = factory;
        this.env.put("java.naming.factory.initial", config.getInitialContextFactory());
        this.env.put("java.naming.provider.url", config.getCatalogBaseDn());
        try {
            DirContext ctx = (DirContext)factory.getInitialContext(this.env);
            this.catalog = new KerberosCatalog((Map)this.execute(ctx, (ContextOperation)new GetCatalog()));
        }
        catch (Exception e) {
            String message = "Failed to get catalog context " + (String)this.env.get("java.naming.provider.url");
            throw new ServiceConfigurationException(message, (Throwable)e);
        }
    }

    public String addPrincipal(PrincipalStoreEntry entry) throws Exception {
        this.env.put("java.naming.provider.url", this.catalog.getBaseDn(entry.getRealmName()));
        try {
            DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
            return (String)this.execute(ctx, new AddPrincipal(entry));
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public String deletePrincipal(KerberosPrincipal principal) throws Exception {
        this.env.put("java.naming.provider.url", this.catalog.getBaseDn(principal.getRealm()));
        try {
            DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
            return (String)this.execute(ctx, new DeletePrincipal(principal));
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public PrincipalStoreEntry[] getAllPrincipals(String realm) throws Exception {
        this.env.put("java.naming.provider.url", this.catalog.getBaseDn(realm));
        try {
            DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
            return (PrincipalStoreEntry[])this.execute(ctx, new GetAllPrincipals());
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        this.env.put("java.naming.provider.url", this.catalog.getBaseDn(principal.getRealm()));
        try {
            DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
            return (PrincipalStoreEntry)this.execute(ctx, new GetPrincipal(principal));
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        this.env.put("java.naming.provider.url", this.catalog.getBaseDn(principal.getRealm()));
        try {
            DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
            return (String)this.execute(ctx, new ChangePassword(principal, newPassword));
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    private Object execute(DirContext ctx, ContextOperation operation) throws Exception {
        return operation.execute(ctx, null);
    }
}

