/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.spi.DirStateFactory;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class PrincipalStateFactory
implements DirStateFactory {
    public DirStateFactory.Result getStateToBind(Object obj, Name name, Context nameCtx, Hashtable environment, Attributes inAttrs) throws NamingException {
        if (obj instanceof PrincipalStoreEntry) {
            Attributes outAttrs = inAttrs == null ? new AttributesImpl(true) : (Attributes)inAttrs.clone();
            Attribute oc = outAttrs.get("objectClass");
            if (oc == null) {
                oc = new AttributeImpl("objectClass");
                outAttrs.put(oc);
            }
            if (!AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"top")) {
                oc.add("top");
            }
            PrincipalStoreEntry p = (PrincipalStoreEntry)obj;
            if (!AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"uidObject")) {
                oc.add("uidObject");
                if (p.getUserId() != null) {
                    outAttrs.put("uid", p.getUserId());
                } else {
                    throw new SchemaViolationException("Person must have uid.");
                }
            }
            if (!AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"extensibleObject")) {
                oc.add("extensibleObject");
                outAttrs.put("apacheSamType", "7");
            }
            if (!AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"person") && !oc.contains("2.5.6.6")) {
                oc.add("person");
                outAttrs.put("sn", p.getUserId());
                outAttrs.put("cn", p.getCommonName());
            }
            if (!AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"organizationalPerson") && !oc.contains("2.5.6.7")) {
                oc.add("organizationalPerson");
            }
            if (!AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"inetOrgPerson") && !oc.contains("2.16.840.1.113730.3.2.2")) {
                oc.add("inetOrgPerson");
            }
            if (!oc.contains("krb5Principal")) {
                oc.add("krb5Principal");
            }
            if (!oc.contains("krb5KDCEntry")) {
                oc.add("krb5KDCEntry");
                String principal = p.getPrincipal().getName();
                EncryptionKey encryptionKey = p.getKeyMap().get(EncryptionType.DES_CBC_MD5);
                try {
                    outAttrs.put("krb5Key", EncryptionKeyEncoder.encode(encryptionKey));
                }
                catch (IOException ioe) {
                    throw new InvalidAttributeValueException("Unable to encode Kerberos key.");
                }
                int keyVersion = encryptionKey.getKeyVersion();
                outAttrs.put("krb5PrincipalName", principal);
                outAttrs.put("krb5KeyVersionNumber", Integer.toString(keyVersion));
            }
            DirStateFactory.Result r = new DirStateFactory.Result(obj, outAttrs);
            return r;
        }
        return null;
    }

    public Object getStateToBind(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        throw new UnsupportedOperationException("Structural objectClass needed with additional attributes!");
    }
}

