/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.cache;

import com.phloc.commons.cache.AbstractCache;
import com.phloc.commons.state.EChange;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractNotifyingCache<KEYTYPE, VALUETYPE>
extends AbstractCache<KEYTYPE, VALUETYPE> {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();

    public AbstractNotifyingCache(@Nonnull String string) {
        super(string);
    }

    @Nonnull
    protected abstract VALUETYPE getValueToCache(@Nullable KEYTYPE var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public final VALUETYPE getFromCache(@Nullable KEYTYPE KEYTYPE) {
        Object VALUETYPE;
        this.m_aRWLock.readLock().lock();
        try {
            VALUETYPE = super.getFromCacheNoStats(KEYTYPE);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (VALUETYPE == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                VALUETYPE = super.getFromCacheNoStats(KEYTYPE);
                if (VALUETYPE == null) {
                    VALUETYPE = this.getValueToCache(KEYTYPE);
                    if (VALUETYPE == null) {
                        throw new IllegalStateException("The value to cache was null for key '" + KEYTYPE + "'");
                    }
                    super.putInCache(KEYTYPE, VALUETYPE);
                    this.m_aCacheAccessStats.cacheMiss();
                }
                this.m_aCacheAccessStats.cacheHit();
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
        return VALUETYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final EChange removeFromCache(@Nullable KEYTYPE KEYTYPE) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.removeFromCache(KEYTYPE);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final EChange clearCache() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.clearCache();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }
}

