/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.deadlock;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.deadlock.IThreadDeadlockListener;
import com.phloc.commons.deadlock.ThreadDeadlockInfo;
import com.phloc.commons.state.EChange;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ThreadDeadlockDetector {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ThreadDeadlockDetector.class);
    private final ThreadMXBean m_aMBean = ManagementFactory.getThreadMXBean();
    private final Set<IThreadDeadlockListener> m_aListeners = new CopyOnWriteArraySet<IThreadDeadlockListener>();

    public void run() {
        long[] lArray;
        long[] lArray2 = lArray = this.m_aMBean.isSynchronizerUsageSupported() ? this.m_aMBean.findDeadlockedThreads() : this.m_aMBean.findMonitorDeadlockedThreads();
        if (ArrayHelper.isNotEmpty(lArray)) {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            ThreadDeadlockInfo[] threadDeadlockInfoArray = new ThreadDeadlockInfo[lArray.length];
            for (int i = 0; i < threadDeadlockInfoArray.length; ++i) {
                ThreadInfo object = this.m_aMBean.getThreadInfo(lArray[i]);
                Thread thread = null;
                StackTraceElement[] stackTraceElementArray = null;
                for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                    if (entry.getKey().getId() != object.getThreadId()) continue;
                    thread = entry.getKey();
                    stackTraceElementArray = entry.getValue();
                    break;
                }
                if (thread == null) {
                    throw new IllegalStateException("Deadlocked Thread not found as defined by " + object.toString());
                }
                threadDeadlockInfoArray[i] = new ThreadDeadlockInfo(object, thread, stackTraceElementArray);
            }
            for (IThreadDeadlockListener iThreadDeadlockListener : this.m_aListeners) {
                iThreadDeadlockListener.onDeadlockDetected(threadDeadlockInfoArray);
            }
            if (this.m_aListeners.isEmpty()) {
                s_aLogger.warn("Found a deadlock of " + threadDeadlockInfoArray.length + " threads but no listeners are present!");
            }
        }
    }

    @Nonnull
    public EChange addListener(@Nonnull IThreadDeadlockListener iThreadDeadlockListener) {
        if (iThreadDeadlockListener == null) {
            throw new NullPointerException("listener");
        }
        return EChange.valueOf(this.m_aListeners.add(iThreadDeadlockListener));
    }

    @Nonnull
    public EChange removeListener(@Nullable IThreadDeadlockListener iThreadDeadlockListener) {
        return EChange.valueOf(this.m_aListeners.remove(iThreadDeadlockListener));
    }

    @Nonnull
    public EChange removeAllListeners() {
        if (this.m_aListeners.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aListeners.clear();
        return EChange.CHANGED;
    }

    @Nonnegative
    public int getListenerCount() {
        return this.m_aListeners.size();
    }
}

