/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.deadlock;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.lang.management.ThreadInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ThreadDeadlockInfo {
    private final ThreadInfo m_aThreadInfo;
    private final Thread m_aThread;
    private final StackTraceElement[] m_aStackTrace;

    public ThreadDeadlockInfo(@Nonnull ThreadInfo threadInfo, @Nonnull Thread thread, @Nullable StackTraceElement[] stackTraceElementArray) {
        if (threadInfo == null) {
            throw new NullPointerException("threadInfo");
        }
        if (thread == null) {
            throw new NullPointerException("thread");
        }
        this.m_aThreadInfo = threadInfo;
        this.m_aThread = thread;
        this.m_aStackTrace = ArrayHelper.getCopy(stackTraceElementArray);
    }

    @Nonnull
    public ThreadInfo getThreadInfo() {
        return this.m_aThreadInfo;
    }

    @Nonnull
    public Thread getThread() {
        return this.m_aThread;
    }

    public boolean hasStackTrace() {
        return this.m_aStackTrace != null;
    }

    @Nullable
    @ReturnsMutableCopy
    public StackTraceElement[] getStackTrace() {
        return ArrayHelper.getCopy(this.m_aStackTrace);
    }

    public String toString() {
        return new ToStringGenerator(this).append("threadInfo", this.m_aThreadInfo).append("thread", this.m_aThread).appendIfNotNull("stackTrace", this.m_aStackTrace).toString();
    }
}

