/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.hash;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.hash.HashCodeCalculator;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.hash.IHashCodeImplementation;
import com.phloc.commons.hash.IHashCodeImplementationRegistrarSPI;
import com.phloc.commons.hash.IHashCodeImplementationRegistry;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@IsSPIImplementation
public final class DefaultHashCodeImplementationRegistrarSPI
implements IHashCodeImplementationRegistrarSPI {
    @Override
    public void registerHashCodeImplementations(@Nonnull IHashCodeImplementationRegistry iHashCodeImplementationRegistry) {
        iHashCodeImplementationRegistry.registerHashCodeImplementation(StringBuffer.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                return object.toString().hashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(StringBuilder.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                return object.toString().hashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Node.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                Node node = (Node)object;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(node).append(node.getNodeType()).append(node.getNodeName()).append(node.getLocalName()).append(node.getNamespaceURI()).append(node.getPrefix()).append(node.getNodeValue());
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                hashCodeGenerator = hashCodeGenerator.append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(nodeList.item(i));
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicBoolean.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                return HashCodeCalculator.append(0, ((AtomicBoolean)object).get());
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicInteger.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                return HashCodeCalculator.append(0, ((AtomicInteger)object).get());
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicLong.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                return HashCodeCalculator.append(0, ((AtomicLong)object).get());
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(boolean[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                boolean[] blArray = (boolean[])object;
                int n = blArray.length;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(blArray[i]);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(byte[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                byte[] byArray = (byte[])object;
                int n = byArray.length;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(byArray[i]);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(char[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                char[] cArray = (char[])object;
                int n = cArray.length;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(cArray[i]);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(double[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                double[] dArray = (double[])object;
                int n = dArray.length;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(dArray[i]);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(float[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                float[] fArray = (float[])object;
                int n = fArray.length;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(fArray[i]);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(int[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                int[] nArray = (int[])object;
                int n = nArray.length;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(nArray[i]);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(long[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                long[] lArray = (long[])object;
                int n = lArray.length;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(lArray[i]);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(short[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                short[] sArray = (short[])object;
                int n = sArray.length;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
                for (int i = 0; i < n; ++i) {
                    hashCodeGenerator = hashCodeGenerator.append(sArray[i]);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Map.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                Map map = (Map)object;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(map).append(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    hashCodeGenerator = hashCodeGenerator.append(entry.getKey()).append(entry.getValue());
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Collection.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                Collection collection = (Collection)object;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(collection).append(collection.size());
                for (Object e : collection) {
                    hashCodeGenerator = hashCodeGenerator.append(e);
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Iterator.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                Iterator iterator = (Iterator)object;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(iterator);
                while (iterator.hasNext()) {
                    hashCodeGenerator = hashCodeGenerator.append(iterator.next());
                }
                return hashCodeGenerator.getHashCode();
            }
        });
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Enumeration.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object object) {
                Enumeration enumeration = (Enumeration)object;
                HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(enumeration);
                while (enumeration.hasMoreElements()) {
                    hashCodeGenerator = hashCodeGenerator.append(enumeration.nextElement());
                }
                return hashCodeGenerator.getHashCode();
            }
        });
    }
}

