/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.file.EFileIOErrorCode;
import com.phloc.commons.io.file.EFileIOOperation;
import com.phloc.commons.io.file.FileIOError;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.streams.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileOperations {
    public static final boolean DEFAULT_WARN_ON_DELETE_ROOT = true;
    private static final FileOperations s_aInstance = new FileOperations();
    private static boolean s_bWarnOnDeleteRoot = true;

    private FileOperations() {
    }

    public static boolean isWarnOnDeleteRoot() {
        return s_bWarnOnDeleteRoot;
    }

    public static void setWarnOnDeleteRoot(boolean bl) {
        s_bWarnOnDeleteRoot = bl;
    }

    @Nonnull
    public static FileIOError createDir(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        if (file.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.CREATE_DIR, file);
        }
        File file2 = file.getParentFile();
        if (file2 != null && file2.exists() && !FileUtils.canWrite(file2)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.CREATE_DIR, file);
        }
        try {
            EFileIOErrorCode eFileIOErrorCode = file.mkdir() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.CREATE_DIR, file);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.CREATE_DIR, securityException);
        }
    }

    @Nonnull
    public static FileIOError createDirIfNotExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.createDir(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.TARGET_ALREADY_EXISTS)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.CREATE_DIR, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError createDirRecursive(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        if (file.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, file);
        }
        File file2 = file.getParentFile();
        if (file2 != null && file2.exists() && !FileUtils.canWrite(file2)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, file);
        }
        try {
            EFileIOErrorCode eFileIOErrorCode = file.mkdirs() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, file);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, securityException);
        }
    }

    @Nonnull
    public static FileIOError createDirRecursiveIfNotExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.createDirRecursive(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.TARGET_ALREADY_EXISTS)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteDir(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        if (!FileUtils.existsDir(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        if (FileOperations.isWarnOnDeleteRoot() && file.getAbsoluteFile().getParent() == null) {
            throw new IllegalArgumentException("Aren't we deleting the full drive: '" + file.getAbsolutePath() + "'");
        }
        File file2 = file.getParentFile();
        if (file2 != null && !FileUtils.canWrite(file2)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        try {
            EFileIOErrorCode eFileIOErrorCode = file.delete() && !file.exists() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.DELETE_DIR, securityException);
        }
    }

    @Nonnull
    public static FileIOError deleteDirIfExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.deleteDir(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteDirRecursive(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        if (!FileUtils.existsDir(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, file);
        }
        if (FileOperations.isWarnOnDeleteRoot() && file.getAbsoluteFile().getParent() == null) {
            throw new IllegalArgumentException("Aren't we deleting the full drive: '" + file.getAbsolutePath() + "'");
        }
        File file2 = file.getParentFile();
        if (file2 != null && !FileUtils.canWrite(file2)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, file);
        }
        for (File file3 : FileUtils.getDirectoryContent(file)) {
            FileIOError fileIOError;
            if (file3.isDirectory()) {
                if (FilenameHelper.isSystemInternalDirectory(file3.getName()) || !(fileIOError = FileOperations.deleteDirRecursive(file3)).isFailure()) continue;
                return fileIOError;
            }
            if (file3.isFile()) {
                fileIOError = FileOperations.deleteFile(file3);
                if (!fileIOError.isFailure()) continue;
                return fileIOError;
            }
            return EFileIOErrorCode.OBJECT_CANNOT_BE_HANDLED.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, file3);
        }
        return FileOperations.deleteDir(file);
    }

    @Nonnull
    public static FileIOError deleteDirRecursiveIfExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.deleteDirRecursive(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteFile(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!FileUtils.existsFile(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        File file2 = file.getParentFile();
        if (file2 != null && !FileUtils.canWrite(file2)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        try {
            EFileIOErrorCode eFileIOErrorCode = file.delete() && !file.exists() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.DELETE_FILE, securityException);
        }
    }

    @Nonnull
    public static FileIOError deleteFileIfExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.deleteFile(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError renameFile(@Nonnull File file, @Nonnull File file2) {
        if (file == null) {
            throw new NullPointerException("sourceFile");
        }
        if (file2 == null) {
            throw new NullPointerException("targetFile");
        }
        if (!FileUtils.existsFile(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.RENAME_FILE, file);
        }
        if (FileUtils.safeEquals(file, file2)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.RENAME_FILE, file);
        }
        if (file2.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.RENAME_FILE, file2);
        }
        File file3 = file.getParentFile();
        if (file3 != null && !FileUtils.canWrite(file3)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_FILE, file);
        }
        File file4 = file2.getParentFile();
        if (file4 != null && file4.exists() && !FileUtils.canWrite(file4)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_FILE, file2);
        }
        FileUtils.ensureParentDirectoryIsPresent(file2);
        try {
            EFileIOErrorCode eFileIOErrorCode = file.renameTo(file2) ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.RENAME_FILE, file, file2);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.RENAME_FILE, securityException);
        }
    }

    @Nonnull
    public static FileIOError renameDir(@Nonnull File file, @Nonnull File file2) {
        if (file == null) {
            throw new NullPointerException("sourceDirectory");
        }
        if (file2 == null) {
            throw new NullPointerException("targetDirectory");
        }
        if (!FileUtils.existsDir(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.RENAME_DIR, file);
        }
        if (FileUtils.safeEquals(file, file2)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.RENAME_DIR, file);
        }
        if (file2.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.RENAME_DIR, file2);
        }
        if (FileUtils.isParentDirectory(file, file2)) {
            return EFileIOErrorCode.TARGET_IS_CHILD_OF_SOURCE.getAsIOError(EFileIOOperation.RENAME_DIR, file, file2);
        }
        File file3 = file.getParentFile();
        if (file3 != null && !FileUtils.canWrite(file3)) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_DIR, file);
        }
        File file4 = file2.getParentFile();
        if (file4 != null && file4.exists() && !FileUtils.canWrite(file4)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_DIR, file2);
        }
        FileUtils.ensureParentDirectoryIsPresent(file2);
        try {
            EFileIOErrorCode eFileIOErrorCode = file.renameTo(file2) ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.RENAME_DIR, file, file2);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getAsIOError(EFileIOOperation.RENAME_DIR, securityException);
        }
    }

    @Nonnull
    public static FileIOError copyFile(@Nonnull File file, @Nonnull File file2) {
        if (file == null) {
            throw new NullPointerException("sourceFile");
        }
        if (file2 == null) {
            throw new NullPointerException("targetFile");
        }
        if (!FileUtils.existsFile(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.COPY_FILE, file);
        }
        if (FileUtils.safeEquals(file, file2)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.COPY_FILE, file);
        }
        if (file2.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.COPY_FILE, file2);
        }
        if (!FileUtils.canRead(file)) {
            return EFileIOErrorCode.SOURCE_NOT_READABLE.getAsIOError(EFileIOOperation.COPY_FILE, file);
        }
        File file3 = file2.getParentFile();
        if (file3 != null && file3.exists() && !FileUtils.canWrite(file3)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.COPY_FILE, file2);
        }
        FileUtils.ensureParentDirectoryIsPresent(file2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(FileUtils.getInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(FileUtils.getOutputStream(file2, EAppend.TRUNCATE));
        EFileIOErrorCode eFileIOErrorCode = StreamUtils.copyInputStreamToOutputStreamAndCloseOS(bufferedInputStream, bufferedOutputStream).isSuccess() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
        return eFileIOErrorCode.getAsIOError(EFileIOOperation.COPY_FILE, file, file2);
    }

    @Nonnull
    public static FileIOError copyDirRecursive(@Nonnull File file, @Nonnull File file2) {
        if (file == null) {
            throw new NullPointerException("sourceDirectory");
        }
        if (file2 == null) {
            throw new NullPointerException("targetDirectory");
        }
        if (!FileUtils.existsDir(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file);
        }
        if (FileUtils.safeEquals(file, file2)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file);
        }
        if (FileUtils.isParentDirectory(file, file2)) {
            return EFileIOErrorCode.TARGET_IS_CHILD_OF_SOURCE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file, file2);
        }
        if (file2.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file2);
        }
        if (!FileUtils.canRead(file)) {
            return EFileIOErrorCode.SOURCE_NOT_READABLE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file);
        }
        File file3 = file2.getParentFile();
        if (file3 != null && file3.exists() && !FileUtils.canWrite(file3)) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file2);
        }
        FileIOError fileIOError = FileOperations.createDirRecursive(file2);
        if (fileIOError.isFailure()) {
            return fileIOError;
        }
        for (File file4 : FileUtils.getDirectoryContent(file)) {
            if (file4.isDirectory()) {
                if (FilenameHelper.isSystemInternalDirectory(file4.getName()) || !(fileIOError = FileOperations.copyDirRecursive(file4, new File(file2, file4.getName()))).isFailure()) continue;
                return fileIOError;
            }
            if (file4.isFile()) {
                fileIOError = FileOperations.copyFile(file4, new File(file2, file4.getName()));
                if (!fileIOError.isFailure()) continue;
                return fileIOError;
            }
            return EFileIOErrorCode.OBJECT_CANNOT_BE_HANDLED.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file4);
        }
        return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file, file2);
    }
}

