/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.CGlobal;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.string.StringHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleFileIO {
    private static final SimpleFileIO s_aInstance = new SimpleFileIO();

    private SimpleFileIO() {
    }

    @Nullable
    public static byte[] readFileBytes(@Nullable File file) {
        return file == null ? null : StreamUtils.getAllBytes(FileUtils.getInputStream(file));
    }

    @Nullable
    public static String readFileAsString(@Nullable File file, @Nonnull String string) {
        return file == null ? null : StreamUtils.getAllBytesAsString((InputStream)FileUtils.getInputStream(file), string);
    }

    @Nullable
    public static String readFileAsString(@Nullable File file, @Nonnull Charset charset) {
        return file == null ? null : StreamUtils.getAllBytesAsString((InputStream)FileUtils.getInputStream(file), charset);
    }

    @Nullable
    public static List<String> readFileLines(@Nullable File file, @Nonnull String string) {
        return file == null ? null : StreamUtils.readStreamLines((InputStream)FileUtils.getInputStream(file), string);
    }

    @Nullable
    public static List<String> readFileLines(@Nullable File file, @Nonnull Charset charset) {
        return file == null ? null : StreamUtils.readStreamLines((InputStream)FileUtils.getInputStream(file), charset);
    }

    public static void readFileLines(@Nullable File file, @Nonnull String string, @Nonnull List<String> list) {
        if (file != null) {
            StreamUtils.readStreamLines((InputStream)FileUtils.getInputStream(file), string, list);
        }
    }

    public static void readFileLines(@Nullable File file, @Nonnull Charset charset, @Nonnull List<String> list) {
        if (file != null) {
            StreamUtils.readStreamLines((InputStream)FileUtils.getInputStream(file), charset, list);
        }
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull byte[] byArray) {
        FileOutputStream fileOutputStream = FileUtils.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamUtils.writeStream(fileOutputStream, byArray);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        FileOutputStream fileOutputStream = FileUtils.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamUtils.writeStream(fileOutputStream, byArray, n, n2);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull String string, @Nonnull String string2) {
        FileOutputStream fileOutputStream = FileUtils.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamUtils.writeStream((OutputStream)fileOutputStream, string, string2);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull String string, @Nonnull Charset charset) {
        FileOutputStream fileOutputStream = FileUtils.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamUtils.writeStream((OutputStream)fileOutputStream, string, charset);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull List<String> list, @Nonnull String string) {
        return SimpleFileIO.writeFile(file, StringHelper.getImploded(CGlobal.LINE_SEPARATOR, list), string);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File file, @Nonnull List<String> list, @Nonnull Charset charset) {
        return SimpleFileIO.writeFile(file, StringHelper.getImploded(CGlobal.LINE_SEPARATOR, list), charset);
    }
}

