/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streamprovider;

import com.phloc.commons.io.IInputStreamAndReaderProvider;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ByteArrayInputStreamProvider
implements IInputStreamAndReaderProvider {
    private final byte[] m_aData;
    private final int m_nOfs;
    private final int m_nLen;

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            throw new NullPointerException("input");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("ofs:" + n + ";len=" + n2 + ";bufLen=" + byArray.length);
        }
        this.m_aData = byArray;
        this.m_nOfs = n;
        this.m_nLen = n2;
    }

    @Override
    @Nonnull
    public final InputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aData);
    }

    @Override
    @Nonnull
    public final Reader getReader(@Nonnull String string) {
        return StreamUtils.createReader(this.getInputStream(), string);
    }

    @Override
    @Nonnull
    public final Reader getReader(@Nonnull Charset charset) {
        return StreamUtils.createReader(this.getInputStream(), charset);
    }

    public String toString() {
        return new ToStringGenerator(null).append("byteArray[]", this.m_aData.length + " bytes").append("ofs", this.m_nOfs).append("len", this.m_nLen).toString();
    }
}

