/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mime;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.exceptions.InitializationException;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.microdom.reader.XMLMapHandler;
import com.phloc.commons.mime.CMimeType;
import com.phloc.commons.mime.IMimeType;
import com.phloc.commons.mime.MimeType;
import com.phloc.commons.regex.RegExHelper;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MimeTypeDeterminator {
    private static final Map<String, String> s_aFileExtMap = new HashMap<String, String>();
    private static final byte[] MIME_ID_GIF87A = new byte[]{71, 73, 70, 56, 55, 97};
    private static final byte[] MIME_ID_GIF89A = new byte[]{71, 73, 70, 56, 57, 97};
    private static final byte[] MIME_ID_JPG = new byte[]{-1, -40};
    private static final byte[] MIME_ID_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] MIME_ID_TIFF_MOTOROLLA = new byte[]{77, 77};
    private static final byte[] MIME_ID_TIFF_INTEL = new byte[]{73, 73};
    private static final byte[] MIME_ID_PSD = new byte[]{56, 66, 80, 83};
    private static final byte[] MIME_ID_XML = new byte[]{60, 63, 120, 109, 108};
    private static final byte[] MIME_ID_PDF = new byte[]{37, 80, 68, 70};
    private static final MimeTypeDeterminator s_aInstance;

    private MimeTypeDeterminator() {
    }

    private static boolean _match(@Nonnull byte[] byArray, int n, @Nonnull byte[] byArray2) {
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray2[i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean _match(@Nonnull byte[] byArray, @Nonnull byte[] byArray2) {
        return byArray.length > byArray2.length && MimeTypeDeterminator._match(byArray, 0, byArray2);
    }

    @Nonnull
    public static IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull @Nonempty String string2) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, string2));
    }

    @Nonnull
    public static IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, charset));
    }

    @Nonnull
    public static IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray) {
        if (byArray != null) {
            if (MimeTypeDeterminator._match(byArray, MIME_ID_GIF87A) || MimeTypeDeterminator._match(byArray, MIME_ID_GIF89A)) {
                return CMimeType.IMAGE_GIF;
            }
            if (MimeTypeDeterminator._match(byArray, MIME_ID_JPG)) {
                return CMimeType.IMAGE_JPG;
            }
            if (MimeTypeDeterminator._match(byArray, MIME_ID_PNG)) {
                return CMimeType.IMAGE_PNG;
            }
            if (MimeTypeDeterminator._match(byArray, MIME_ID_TIFF_INTEL) || MimeTypeDeterminator._match(byArray, MIME_ID_TIFF_MOTOROLLA)) {
                return CMimeType.IMAGE_TIFF;
            }
            if (MimeTypeDeterminator._match(byArray, MIME_ID_PSD)) {
                return CMimeType.IMAGE_PSD;
            }
            if (MimeTypeDeterminator._match(byArray, MIME_ID_XML)) {
                return CMimeType.TEXT_XML;
            }
            if (MimeTypeDeterminator._match(byArray, MIME_ID_PDF)) {
                return CMimeType.APPLICATION_PDF;
            }
        }
        return CMimeType.APPLICATION_OCTET_STREAM;
    }

    @Nullable
    public static String getMimeTypeFromFilename(@Nonnull String string) {
        return MimeTypeDeterminator.getMimeTypeFromExtension(FilenameHelper.getExtension(string));
    }

    @Nullable
    public static IMimeType getMimeTypeObjectFromFilename(@Nonnull String string) {
        return MimeType.parseFromStringWithoutEncoding(MimeTypeDeterminator.getMimeTypeFromFilename(string));
    }

    @Nullable
    public static String getMimeTypeFromExtension(@Nonnull String string) {
        String string2 = s_aFileExtMap.get(string);
        if (string2 == null) {
            string2 = s_aFileExtMap.get(string.toLowerCase());
        }
        return string2;
    }

    @Nullable
    public static IMimeType getMimeTypeObjectFromExtension(@Nonnull String string) {
        return MimeType.parseFromStringWithoutEncoding(MimeTypeDeterminator.getMimeTypeFromExtension(string));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Collection<String> getAllKnownMimeTypes() {
        return ContainerHelper.makeUnmodifiable(s_aFileExtMap.values());
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Map<String, String> getAllKnownMimeTypeFilenameMappings() {
        return ContainerHelper.makeUnmodifiable(s_aFileExtMap);
    }

    static {
        if (XMLMapHandler.readMap(new ClassPathResource("codelists/fileext-mimetype-mapping.xml"), s_aFileExtMap).isFailure()) {
            throw new InitializationException("Failed to init file extension to mimetype mapping file");
        }
        if (GlobalDebug.isDebugMode()) {
            for (Map.Entry<String, String> entry : s_aFileExtMap.entrySet()) {
                String string = entry.getKey();
                if (!RegExHelper.stringMatchesPattern("(|[a-zA-Z0-9]+(\\.[a-z0-9]+)*)", string)) {
                    throw new InitializationException("MIME file extension '" + string + "' is invalid!");
                }
                if (!entry.getValue().contains(" ")) continue;
                throw new InitializationException("MIME type '" + entry.getValue() + "' is invalid!");
            }
        }
        s_aInstance = new MimeTypeDeterminator();
    }
}

