/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.system.JavaVersionConstants;
import javax.annotation.Nonnull;

public enum EJavaVersion {
    UNKNOWN,
    JDK_11(45.3, 46.0),
    JDK_12(46.0, 47.0),
    JDK_13(47.0, 48.0),
    JDK_14(48.0, 49.0),
    JDK_15(49.0, 50.0),
    JDK_16(50.0, 51.0),
    JDK_17(51.0, 52.0);

    private static volatile EJavaVersion s_aInstance;
    private final double m_dMinVersionIncl;
    private final double m_dMaxVersionExcl;
    private final boolean m_bIsIt;

    private EJavaVersion() {
        this.m_dMinVersionIncl = Double.NaN;
        this.m_dMaxVersionExcl = Double.NaN;
        this.m_bIsIt = EqualsUtils.equals(Double.NaN, JavaVersionConstants.CLASS_VERSION);
    }

    private EJavaVersion(double d, double d2) {
        this.m_dMinVersionIncl = d;
        this.m_dMaxVersionExcl = d2;
        this.m_bIsIt = this.isMatchingVersion(JavaVersionConstants.CLASS_VERSION);
    }

    protected boolean isMatchingVersion(double d) {
        return d >= this.m_dMinVersionIncl && d < this.m_dMaxVersionExcl;
    }

    public boolean isCurrentVersion() {
        return this.m_bIsIt;
    }

    public boolean isSupportedVersion() {
        return this.m_dMinVersionIncl < EJavaVersion.getCurrentVersion().m_dMaxVersionExcl;
    }

    @Nonnull
    static EJavaVersion getCurrentVersion() {
        EJavaVersion eJavaVersion = s_aInstance;
        if (eJavaVersion == null) {
            for (EJavaVersion eJavaVersion2 : EJavaVersion.values()) {
                if (!eJavaVersion2.m_bIsIt) continue;
                eJavaVersion = eJavaVersion2;
                break;
            }
            if (eJavaVersion == null) {
                eJavaVersion = UNKNOWN;
            }
            s_aInstance = eJavaVersion;
        }
        return eJavaVersion;
    }

    @Nonnull
    public static EJavaVersion getFromMajorAndMinor(int n, int n2) {
        double d = StringParser.parseBigDecimal(n + "." + n2).doubleValue();
        return EJavaVersion.getFromVersionNumber(d);
    }

    @Nonnull
    public static EJavaVersion getFromVersionNumber(double d) {
        for (EJavaVersion eJavaVersion : EJavaVersion.values()) {
            if (!eJavaVersion.isMatchingVersion(d)) continue;
            return eJavaVersion;
        }
        return UNKNOWN;
    }

    static {
        s_aInstance = null;
    }
}

