/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.version;

import com.phloc.commons.IHasStringRepresentation;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Version
implements Comparable<Version>,
IHasStringRepresentation,
Serializable {
    public static final String DEFAULT_VERSION_STRING = "0";
    public static final boolean DEFAULT_PRINT_ZERO_ELEMENTS = false;
    private final int m_nMajor;
    private final int m_nMinor;
    private final int m_nMicro;
    private final String m_sQualifier;

    public Version(@Nonnegative int n) {
        this(n, 0, 0, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2) {
        this(n, n2, 0, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        this(n, n2, n3, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4) {
        this(n, n2, n3, Integer.toString(n4));
    }

    public Version(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nullable String string) {
        this.m_nMajor = n;
        this.m_nMinor = n2;
        this.m_nMicro = n3;
        String string2 = this.m_sQualifier = StringHelper.hasNoText(string) ? null : string;
        if (this.m_nMajor < 0) {
            throw new IllegalArgumentException("Major version " + this.m_nMajor + " is < 0");
        }
        if (this.m_nMinor < 0) {
            throw new IllegalArgumentException("Minor version " + this.m_nMinor + " is < 0");
        }
        if (this.m_nMicro < 0) {
            throw new IllegalArgumentException("Micro version " + this.m_nMicro + " is < 0");
        }
    }

    public Version(@Nullable String string) {
        this(string, true);
    }

    @Nonnull
    private static String[] _extSplit(String string) {
        String[] stringArray = StringHelper.getExplodedArray('.', string, 2);
        if (stringArray.length == 2) {
            return stringArray;
        }
        if (StringParser.isInt(stringArray[0])) {
            return stringArray;
        }
        String[] stringArray2 = StringHelper.getExplodedArray('-', string, 2);
        if (stringArray2.length == 1) {
            return stringArray;
        }
        return stringArray2;
    }

    public Version(@Nullable String string, boolean bl) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.length() == 0) {
            string2 = DEFAULT_VERSION_STRING;
        }
        if (bl) {
            String[] stringArray = StringHelper.getExplodedArray('.', string2, 4);
            this.m_nMajor = stringArray.length > 0 ? StringParser.parseInt(stringArray[0], 0) : 0;
            this.m_nMinor = stringArray.length > 1 ? StringParser.parseInt(stringArray[1], 0) : 0;
            this.m_nMicro = stringArray.length > 2 ? StringParser.parseInt(stringArray[2], 0) : 0;
            this.m_sQualifier = stringArray.length > 3 ? (StringHelper.hasNoText(stringArray[3]) ? null : stringArray[3]) : null;
        } else {
            String string4;
            Integer n = null;
            Integer n2 = null;
            Integer n3 = null;
            String string5 = null;
            boolean bl2 = false;
            String[] stringArray = Version._extSplit(string2);
            n = StringParser.parseIntObj(stringArray[0]);
            if (n == null && StringHelper.hasText(stringArray[0])) {
                string5 = string2;
                bl2 = true;
            }
            String string6 = string4 = !bl2 && stringArray.length > 1 ? stringArray[1] : null;
            if (string4 != null) {
                stringArray = Version._extSplit(string4);
                n2 = StringParser.parseIntObj(stringArray[0]);
                if (n2 == null && StringHelper.hasText(stringArray[0])) {
                    string5 = string4;
                    bl2 = true;
                }
                String string7 = string4 = !bl2 && stringArray.length > 1 ? stringArray[1] : null;
                if (string4 != null) {
                    stringArray = Version._extSplit(string4);
                    n3 = StringParser.parseIntObj(stringArray[0]);
                    if (n3 == null && StringHelper.hasText(stringArray[0])) {
                        string5 = string4;
                        bl2 = true;
                    }
                    if (!bl2 && stringArray.length > 1) {
                        string5 = stringArray[1];
                    }
                }
            }
            this.m_nMajor = n == null ? 0 : n;
            this.m_nMinor = n2 == null ? 0 : n2;
            this.m_nMicro = n3 == null ? 0 : n3;
            String string8 = this.m_sQualifier = StringHelper.hasNoText(string5) ? null : string5;
        }
        if (this.m_nMajor < 0) {
            throw new IllegalArgumentException("Major version " + this.m_nMajor + " is < 0");
        }
        if (this.m_nMinor < 0) {
            throw new IllegalArgumentException("Minor version " + this.m_nMinor + " is < 0");
        }
        if (this.m_nMicro < 0) {
            throw new IllegalArgumentException("Micro version " + this.m_nMicro + " is < 0");
        }
    }

    @Nonnegative
    public int getMajor() {
        return this.m_nMajor;
    }

    @Nonnegative
    public int getMinor() {
        return this.m_nMinor;
    }

    @Nonnegative
    public int getMicro() {
        return this.m_nMicro;
    }

    @Nullable
    public String getQualifier() {
        return this.m_sQualifier;
    }

    @Override
    public int compareTo(@Nonnull Version version) {
        if (version == null) {
            throw new NullPointerException("Cannot compare to null");
        }
        int n = this.m_nMajor - version.m_nMajor;
        if (n == 0 && (n = this.m_nMinor - version.m_nMinor) == 0 && (n = this.m_nMicro - version.m_nMicro) == 0) {
            if (this.m_sQualifier != null) {
                if (version.m_sQualifier != null) {
                    n = this.m_sQualifier.compareTo(version.m_sQualifier);
                    if (n < 0) {
                        n = -1;
                    } else if (n > 0) {
                        n = 1;
                    }
                } else {
                    n = 1;
                }
            } else {
                n = version.m_sQualifier != null ? -1 : 0;
            }
        }
        return n;
    }

    public boolean isGreaterThan(@Nonnull Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterOrEqualThan(@Nonnull Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLowerThan(@Nonnull Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLowerOrEqualThan(@Nonnull Version version) {
        return this.compareTo(version) <= 0;
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.getAsString(false);
    }

    @Nonnull
    public String getAsString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.m_sQualifier != null ? this.m_sQualifier : "");
        if (this.m_nMicro > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMicro);
        }
        if (this.m_nMinor > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMinor);
        }
        if (this.m_nMajor > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMajor);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : DEFAULT_VERSION_STRING;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.m_nMajor == version.m_nMajor && this.m_nMinor == version.m_nMinor && this.m_nMicro == version.m_nMicro && EqualsUtils.equals(this.m_sQualifier, version.m_sQualifier);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMajor).append(this.m_nMinor).append(this.m_nMicro).append(this.m_sQualifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("major", this.m_nMajor).append("minor", this.m_nMinor).append("micro", this.m_nMicro).appendIfNotNull("qualifier", this.m_sQualifier).toString();
    }
}

