/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.exceptions.InitializationException;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.sax.LoggingSAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public final class XMLFactory {
    private static DocumentBuilderFactory s_aDefaultDocBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
    private static DocumentBuilder s_aDefaultDocBuilder = XMLFactory.createDocumentBuilder(s_aDefaultDocBuilderFactory);
    private static SAXParserFactory s_aSaxFactoryNonValidating;
    private static SAXParserFactory s_aSaxFactoryValidating;
    private static final XMLFactory s_aInstance;

    private XMLFactory() {
    }

    @Nonnull
    public static DocumentBuilderFactory createDefaultDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilderFactory createDocumentBuilderFactory(@Nonnull Schema schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        DocumentBuilderFactory documentBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
        documentBuilderFactory.setSchema(schema);
        return documentBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return s_aDefaultDocBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilder getDocumentBuilder() {
        return s_aDefaultDocBuilder;
    }

    @Nonnull
    public static DOMImplementation getDOMImplementation() {
        return s_aDefaultDocBuilder.getDOMImplementation();
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder() {
        return XMLFactory.createDocumentBuilder(s_aDefaultDocBuilderFactory);
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder(@Nonnull Schema schema) {
        return XMLFactory.createDocumentBuilder(XMLFactory.createDocumentBuilderFactory(schema));
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder(@Nonnull DocumentBuilderFactory documentBuilderFactory) {
        if (documentBuilderFactory == null) {
            throw new NullPointerException("docBuilderFactory");
        }
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(LoggingSAXErrorHandler.getInstance());
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InitializationException("Failed to create document builder", parserConfigurationException);
        }
    }

    @Nonnull
    public static SAXParserFactory getSaxParserFactory(boolean bl) {
        return bl ? s_aSaxFactoryValidating : s_aSaxFactoryNonValidating;
    }

    @Nonnull
    public static SAXParser createSaxParser(boolean bl) {
        try {
            return XMLFactory.getSaxParserFactory(bl).newSAXParser();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to create new SAX parser", throwable);
        }
    }

    @Nonnull
    public static Document newDocument() {
        return XMLFactory.newDocument(s_aDefaultDocBuilder, null);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder) {
        return XMLFactory.newDocument(documentBuilder, null);
    }

    @Nonnull
    public static Document newDocument(@Nullable EXMLVersion eXMLVersion) {
        return XMLFactory.newDocument(s_aDefaultDocBuilder, eXMLVersion);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder, @Nullable EXMLVersion eXMLVersion) {
        if (documentBuilder == null) {
            throw new NullPointerException("docBuilder");
        }
        Document document = documentBuilder.newDocument();
        document.setXmlVersion((eXMLVersion != null ? eXMLVersion : EXMLVersion.DEFAULT).getVersion());
        return document;
    }

    @Nonnull
    public static Document newDocument(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        return XMLFactory.newDocument(null, string, string2, string3);
    }

    @Nonnull
    public static Document newDocument(@Nullable EXMLVersion eXMLVersion, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        return XMLFactory.newDocument(s_aDefaultDocBuilder, eXMLVersion, string, string2, string3);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder, @Nullable EXMLVersion eXMLVersion, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        if (documentBuilder == null) {
            throw new NullPointerException("docBuilder");
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(string, string2, string3);
        Document document = dOMImplementation.createDocument(string3, string, documentType);
        document.setXmlVersion((eXMLVersion != null ? eXMLVersion : EXMLVersion.DEFAULT).getVersion());
        return document;
    }

    static {
        try {
            s_aSaxFactoryNonValidating = SAXParserFactory.newInstance();
            s_aSaxFactoryNonValidating.setNamespaceAware(true);
            s_aSaxFactoryValidating = SAXParserFactory.newInstance();
            s_aSaxFactoryValidating.setNamespaceAware(true);
            s_aSaxFactoryValidating.setValidating(true);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new InitializationException("Failed to create SAX parser factory", factoryConfigurationError);
        }
        s_aInstance = new XMLFactory();
    }
}

