/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.schema;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.cache.convert.SimpleCacheWithConversion;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.convert.IUnidirectionalConverter;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.sax.LoggingSAXErrorHandler;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public abstract class AbstractSchemaCache
extends SimpleCacheWithConversion<String, Schema> {
    private static final String PREFIX_SYNTHETIC = "synthetic:";
    private final String m_sSchemaTypeName;

    public AbstractSchemaCache(@Nonnull String string) {
        super(AbstractSchemaCache.class.getName() + "$" + string);
        this.m_sSchemaTypeName = string;
    }

    @Nonnull
    protected abstract SchemaFactory internalGetSchemaFactory();

    @Nonnull
    private Schema _getSchema(@Nonnull String string, final @Nonnull Source[] sourceArray) {
        return this.getFromCache(string, new IUnidirectionalConverter<String, Schema>(){

            @Override
            @Nonnull
            public Schema convert(String string) {
                try {
                    Schema schema = AbstractSchemaCache.this.internalGetSchemaFactory().newSchema(sourceArray);
                    if (schema == null) {
                        throw new IllegalStateException("Failed to create " + AbstractSchemaCache.this.m_sSchemaTypeName + " from " + Arrays.toString(sourceArray));
                    }
                    return schema;
                }
                catch (SAXException sAXException) {
                    throw new IllegalArgumentException("Failed to parse " + AbstractSchemaCache.this.m_sSchemaTypeName + " from " + Arrays.toString(sourceArray), sAXException);
                }
            }
        });
    }

    @Nonnull
    public final Schema getSchema(@Nonnull IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            throw new NullPointerException("resources");
        }
        return this._getSchema(iReadableResource.getResourceID(), new Source[]{TransformSourceFactory.create(iReadableResource)});
    }

    @Nonnull
    private Schema _getSchema(@Nonnull @Nonempty Set<IReadableResource> set) {
        if (set.size() == 1) {
            return this.getSchema(ContainerHelper.getFirstElement(set));
        }
        Source[] sourceArray = new Source[set.size()];
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(PREFIX_SYNTHETIC);
        for (IReadableResource iReadableResource : set) {
            if (n > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(iReadableResource.getResourceID());
            sourceArray[n++] = TransformSourceFactory.create(iReadableResource);
        }
        return this._getSchema(stringBuilder.toString(), sourceArray);
    }

    @Nonnull
    public final Schema getSchema(IReadableResource ... iReadableResourceArray) {
        if (ArrayHelper.isEmpty(iReadableResourceArray)) {
            throw new IllegalArgumentException("no resources provided!");
        }
        return this._getSchema(ContainerHelper.newOrderedSet(iReadableResourceArray));
    }

    @Nonnull
    public final Schema getSchema(@Nonnull @Nonempty List<? extends IReadableResource> list) {
        if (ContainerHelper.isEmpty(list)) {
            throw new IllegalArgumentException("no resources provided!");
        }
        return this._getSchema(ContainerHelper.newOrderedSet(list));
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("schemaTypeName", this.m_sSchemaTypeName).toString();
    }

    @Nonnull
    public static final Validator getValidatorFromSchema(@Nonnull Schema schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        Validator validator = schema.newValidator();
        validator.setErrorHandler(LoggingSAXErrorHandler.getInstance());
        return validator;
    }
}

