/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.xml.transform.ResourceStreamSource;
import com.phloc.commons.xml.transform.StringStreamSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

@Immutable
public final class TransformSourceFactory {
    private TransformSourceFactory() {
    }

    @Nonnull
    public static StreamSource create(@Nonnull File file) {
        return new StreamSource(file);
    }

    @Nonnull
    public static ResourceStreamSource create(@Nonnull URL uRL) {
        return TransformSourceFactory.create(new URLResource(uRL));
    }

    @Nonnull
    public static StreamSource create(@Nonnull IInputStreamProvider iInputStreamProvider) {
        if (iInputStreamProvider instanceof IReadableResource) {
            return TransformSourceFactory.create((IReadableResource)iInputStreamProvider);
        }
        return TransformSourceFactory.create(iInputStreamProvider.getInputStream());
    }

    @Nonnull
    public static ResourceStreamSource create(@Nonnull IReadableResource iReadableResource) {
        return new ResourceStreamSource(iReadableResource);
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull String string) {
        return new StringStreamSource(string);
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull char[] cArray) {
        return TransformSourceFactory.create(new String(cArray));
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return TransformSourceFactory.create(new String(cArray, n, n2));
    }

    @Nonnull
    public static StreamSource create(@Nonnull byte[] byArray) {
        return TransformSourceFactory.create(new NonBlockingByteArrayInputStream(byArray));
    }

    @Nonnull
    public static StreamSource create(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return TransformSourceFactory.create(new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull CharSequence charSequence) {
        if (charSequence instanceof String) {
            return TransformSourceFactory.create((String)charSequence);
        }
        return TransformSourceFactory.create(((Object)charSequence).toString());
    }

    @Nonnull
    public static StreamSource create(@Nullable InputStream inputStream) {
        return new StreamSource(inputStream);
    }

    @Nonnull
    public static StreamSource create(@Nullable Reader reader) {
        return new StreamSource(reader);
    }

    @Nonnull
    public static DOMSource create(@Nullable Node node) {
        return new DOMSource(node);
    }
}

