/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharIterator;

public abstract class AbstractCharCollection
implements CharCollection {
    protected AbstractCharCollection() {
    }

    @Override
    @Nonnull
    public abstract CharIterator iterator();

    @Override
    @Nonnegative
    public abstract int size();

    @Override
    public boolean add(char c) {
        throw new UnsupportedOperationException("add(char) is not supported.");
    }

    @Override
    public boolean addAll(@Nonnull CharCollection charCollection) {
        boolean bl = false;
        CharIterator charIterator = charCollection.iterator();
        while (charIterator.hasNext()) {
            bl |= this.add(charIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            charIterator.next();
            charIterator.remove();
        }
    }

    @Override
    public boolean contains(char c) {
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            if (charIterator.next() != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull CharCollection charCollection) {
        CharIterator charIterator = charCollection.iterator();
        while (charIterator.hasNext()) {
            if (this.contains(charIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean removeElement(char c) {
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            if (charIterator.next() != c) continue;
            charIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull CharCollection charCollection) {
        boolean bl = false;
        CharIterator charIterator = charCollection.iterator();
        while (charIterator.hasNext()) {
            bl |= this.removeElement(charIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull CharCollection charCollection) {
        boolean bl = false;
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            if (charCollection.contains(charIterator.next())) continue;
            charIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public char[] toArray() {
        char[] cArray = new char[this.size()];
        int n = 0;
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            cArray[n++] = charIterator.next();
        }
        return cArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public char[] toArray(@Nonnull char[] cArray) {
        if (cArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            cArray[n++] = charIterator.next();
        }
        return cArray;
    }
}

