/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;

public abstract class AbstractFloatCollection
implements FloatCollection {
    protected AbstractFloatCollection() {
    }

    @Override
    @Nonnull
    public abstract FloatIterator iterator();

    @Override
    @Nonnegative
    public abstract int size();

    @Override
    public boolean add(float f) {
        throw new UnsupportedOperationException("add(float) is not supported.");
    }

    @Override
    public boolean addAll(@Nonnull FloatCollection floatCollection) {
        boolean bl = false;
        FloatIterator floatIterator = floatCollection.iterator();
        while (floatIterator.hasNext()) {
            bl |= this.add(floatIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            floatIterator.next();
            floatIterator.remove();
        }
    }

    @Override
    public boolean contains(float f) {
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (floatIterator.next() != f) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull FloatCollection floatCollection) {
        FloatIterator floatIterator = floatCollection.iterator();
        while (floatIterator.hasNext()) {
            if (this.contains(floatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean removeElement(float f) {
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (floatIterator.next() != f) continue;
            floatIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull FloatCollection floatCollection) {
        boolean bl = false;
        FloatIterator floatIterator = floatCollection.iterator();
        while (floatIterator.hasNext()) {
            bl |= this.removeElement(floatIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull FloatCollection floatCollection) {
        boolean bl = false;
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (floatCollection.contains(floatIterator.next())) continue;
            floatIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public float[] toArray() {
        float[] fArray = new float[this.size()];
        int n = 0;
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            fArray[n++] = floatIterator.next();
        }
        return fArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public float[] toArray(@Nonnull float[] fArray) {
        if (fArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            fArray[n++] = floatIterator.next();
        }
        return fArray;
    }
}

