/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.RandomAccessDoubleList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayDoubleList
extends RandomAccessDoubleList
implements Serializable {
    private transient double[] _data;
    private int _size;

    public ArrayDoubleList() {
        this(8);
    }

    public ArrayDoubleList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new double[n];
        this._size = 0;
    }

    public ArrayDoubleList(@Nonnull DoubleCollection doubleCollection) {
        this(doubleCollection.size());
        this.addAll(doubleCollection);
    }

    public ArrayDoubleList(@Nonnull double[] dArray) {
        this(dArray.length);
        System.arraycopy(dArray, 0, this._data, 0, dArray.length);
        this._size = dArray.length;
    }

    @Override
    public double get(int n) {
        this._checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public double removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        double d = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return d;
    }

    @Override
    public double set(int n, double d) {
        this._checkRange(n);
        this.incrModCount();
        double d2 = this._data[n];
        this._data[n] = d;
        return d2;
    }

    @Override
    public void add(int n, double d) {
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = d;
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    @Override
    public boolean addAll(@Nonnull DoubleCollection doubleCollection) {
        return this.addAll(this.size(), doubleCollection);
    }

    @Override
    public boolean addAll(int n, @Nonnull DoubleCollection doubleCollection) {
        if (doubleCollection.size() == 0) {
            return false;
        }
        int n2 = n;
        this._checkRangeIncludingEndpoint(n2);
        this.incrModCount();
        this.ensureCapacity(this._size + doubleCollection.size());
        if (n2 != this._size) {
            System.arraycopy(this._data, n2, this._data, n2 + doubleCollection.size(), this._size - n2);
        }
        DoubleIterator doubleIterator = doubleCollection.iterator();
        while (doubleIterator.hasNext()) {
            this._data[n2] = doubleIterator.next();
            ++n2;
        }
        this._size += doubleCollection.size();
        return true;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            double[] dArray = this._data;
            this._data = new double[n2 < n ? n : n2];
            System.arraycopy(dArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            double[] dArray = this._data;
            this._data = new double[this._size];
            System.arraycopy(dArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeDouble(this._data[i]);
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new double[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readDouble();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

