/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.hash.HashCodeGenerator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.AbstractByteCollection;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.ByteList;
import org.apache.commons.collections.primitives.ByteListIterator;

public abstract class RandomAccessByteList
extends AbstractByteCollection
implements ByteList {
    private int _modCount = 0;

    protected RandomAccessByteList() {
    }

    @Override
    public abstract byte get(int var1);

    @Override
    public abstract int size();

    @Override
    public byte removeElementAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte set(int n, byte by) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, byte by) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(byte by) {
        this.add(this.size(), by);
        return true;
    }

    @Override
    public boolean addAll(int n, @Nonnull ByteCollection byteCollection) {
        int n2 = n;
        boolean bl = false;
        ByteIterator byteIterator = byteCollection.iterator();
        while (byteIterator.hasNext()) {
            this.add(n2++, byteIterator.next());
            bl = true;
        }
        return bl;
    }

    @Override
    public int indexOf(byte by) {
        int n = 0;
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (byteIterator.next() == by) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte by) {
        ByteListIterator byteListIterator = this.listIterator(this.size());
        while (byteListIterator.hasPrevious()) {
            if (byteListIterator.previous() != by) continue;
            return byteListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public ByteIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ByteListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ByteListIterator listIterator(int n) {
        return new RandomAccessByteListIterator(this, n);
    }

    @Override
    public ByteList subList(int n, int n2) {
        return new RandomAccessByteSubList(this, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteList)) {
            return false;
        }
        ByteList byteList = (ByteList)object;
        if (this.size() != byteList.size()) {
            return false;
        }
        ByteIterator byteIterator = byteList.iterator();
        ByteIterator byteIterator2 = this.iterator();
        while (byteIterator2.hasNext()) {
            if (byteIterator2.next() == byteIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            hashCodeGenerator.append(byteIterator.next());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            stringBuilder.append(byteIterator.next());
            if (!byteIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessByteSubList
    extends RandomAccessByteList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessByteList _list = null;
        private ComodChecker _comod = null;

        RandomAccessByteSubList(RandomAccessByteList randomAccessByteList, int n, int n2) {
            if (n < 0 || n2 > randomAccessByteList.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this._list = randomAccessByteList;
            this._offset = n;
            this._limit = n2 - n;
            this._comod = new ComodChecker(randomAccessByteList);
            this._comod.resyncModCount();
        }

        @Override
        public byte get(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(n));
        }

        @Override
        public byte removeElementAt(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            byte by = this._list.removeElementAt(this.toUnderlyingIndex(n));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return by;
        }

        @Override
        public byte set(int n, byte by) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            byte by2 = this._list.set(this.toUnderlyingIndex(n), by);
            this.incrModCount();
            this._comod.resyncModCount();
            return by2;
        }

        @Override
        public void add(int n, byte by) {
            this.checkRangeIncludingEndpoint(n);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(n), by);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int n) {
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int n) {
            return n + this._offset;
        }
    }

    protected static class RandomAccessByteListIterator
    extends ComodChecker
    implements ByteListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessByteListIterator(RandomAccessByteList randomAccessByteList, int n) {
            super(randomAccessByteList);
            if (n < 0 || n > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + n + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = n;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public byte next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte by = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return by;
        }

        @Override
        public byte previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            byte by = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return by;
        }

        @Override
        public void add(byte by) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, by);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (this._lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this._lastReturnedIndex == this._nextIndex) {
                this.getList().removeElementAt(this._lastReturnedIndex);
            } else {
                this.getList().removeElementAt(this._lastReturnedIndex);
                --this._nextIndex;
            }
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void set(byte by) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, by);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessByteList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessByteList randomAccessByteList) {
            this._source = randomAccessByteList;
            this.resyncModCount();
        }

        protected RandomAccessByteList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

