/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ArrayShortList;
import org.apache.commons.collections.primitives.ShortIterator;
import org.apache.commons.collections.primitives.ShortList;
import org.apache.commons.collections.primitives.ShortListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableShortIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableShortList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableShortListIterator;

public final class ShortCollections {
    public static final ShortList EMPTY_SHORT_LIST = ShortCollections.unmodifiableShortList(new ArrayShortList(0));
    public static final ShortIterator EMPTY_SHORT_ITERATOR = ShortCollections.unmodifiableShortIterator(EMPTY_SHORT_LIST.iterator());
    public static final ShortListIterator EMPTY_SHORT_LIST_ITERATOR = ShortCollections.unmodifiableShortListIterator(EMPTY_SHORT_LIST.listIterator());

    private ShortCollections() {
    }

    @Nonnull
    public static ShortList singletonShortList(short s) {
        ArrayShortList arrayShortList = new ArrayShortList(1);
        arrayShortList.add(s);
        return UnmodifiableShortList.wrap(arrayShortList);
    }

    @Nonnull
    public static ShortIterator singletonShortIterator(short s) {
        return ShortCollections.singletonShortList(s).iterator();
    }

    @Nonnull
    public static ShortListIterator singletonShortListIterator(short s) {
        return ShortCollections.singletonShortList(s).listIterator();
    }

    @Nonnull
    public static ShortList unmodifiableShortList(@Nonnull ShortList shortList) throws NullPointerException {
        if (null == shortList) {
            throw new NullPointerException();
        }
        return UnmodifiableShortList.wrap(shortList);
    }

    @Nonnull
    public static ShortIterator unmodifiableShortIterator(@Nonnull ShortIterator shortIterator) {
        if (null == shortIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableShortIterator.wrap(shortIterator);
    }

    @Nonnull
    public static ShortListIterator unmodifiableShortListIterator(@Nonnull ShortListIterator shortListIterator) {
        if (null == shortListIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableShortListIterator.wrap(shortListIterator);
    }

    @Nonnull
    public static ShortList getEmptyShortList() {
        return EMPTY_SHORT_LIST;
    }

    @Nonnull
    public static ShortIterator getEmptyShortIterator() {
        return EMPTY_SHORT_ITERATOR;
    }

    @Nonnull
    public static ShortListIterator getEmptyShortListIterator() {
        return EMPTY_SHORT_LIST_ITERATOR;
    }
}

