/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.adapters.FloatCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorFloatIterator;

abstract class AbstractCollectionFloatCollection
implements FloatCollection {
    protected AbstractCollectionFloatCollection() {
    }

    @Nonnull
    protected abstract Collection<Float> getCollection();

    @Override
    public boolean add(float f) {
        return this.getCollection().add(Float.valueOf(f));
    }

    @Override
    public boolean addAll(@Nonnull FloatCollection floatCollection) {
        return this.getCollection().addAll(FloatCollectionCollection.wrap(floatCollection));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(float f) {
        return this.getCollection().contains(Float.valueOf(f));
    }

    @Override
    public boolean containsAll(@Nonnull FloatCollection floatCollection) {
        return this.getCollection().containsAll(FloatCollectionCollection.wrap(floatCollection));
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    @Nonnull
    public FloatIterator iterator() {
        return IteratorFloatIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(float f) {
        return this.getCollection().remove(Float.valueOf(f));
    }

    @Override
    public boolean removeAll(@Nonnull FloatCollection floatCollection) {
        return this.getCollection().removeAll(FloatCollectionCollection.wrap(floatCollection));
    }

    @Override
    public boolean retainAll(@Nonnull FloatCollection floatCollection) {
        return this.getCollection().retainAll(FloatCollectionCollection.wrap(floatCollection));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.getCollection().size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public float[] toArray() {
        Object[] objectArray = this.getCollection().toArray();
        float[] fArray = new float[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            fArray[i] = ((Float)objectArray[i]).floatValue();
        }
        return fArray;
    }

    @Override
    @Nonnull
    public float[] toArray(@Nonnull float[] fArray) {
        float[] fArray2 = fArray;
        Object[] objectArray = this.getCollection().toArray();
        if (fArray2.length < objectArray.length) {
            fArray2 = new float[objectArray.length];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            fArray2[i] = ((Float)objectArray[i]).floatValue();
        }
        return fArray2;
    }

    public String toString() {
        return this.getCollection().toString();
    }
}

