/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.CharList;
import org.apache.commons.collections.primitives.CharListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionCharCollection;
import org.apache.commons.collections.primitives.adapters.CharCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ListCharList;
import org.apache.commons.collections.primitives.adapters.ListIteratorCharListIterator;

abstract class AbstractListCharList
extends AbstractCollectionCharCollection
implements CharList {
    AbstractListCharList() {
    }

    @Override
    @Nonnull
    protected final Collection<Character> getCollection() {
        return this.getList();
    }

    @Nonnull
    protected abstract List<Character> getList();

    @Override
    public void add(int n, char c) {
        this.getList().add(n, Character.valueOf(c));
    }

    @Override
    public boolean addAll(int n, @Nonnull CharCollection charCollection) {
        return this.getList().addAll(n, CharCollectionCollection.wrap(charCollection));
    }

    @Override
    public char get(int n) {
        return this.getList().get(n).charValue();
    }

    @Override
    public int indexOf(char c) {
        return this.getList().indexOf(Character.valueOf(c));
    }

    @Override
    public int lastIndexOf(char c) {
        return this.getList().lastIndexOf(Character.valueOf(c));
    }

    @Override
    @Nonnull
    public CharListIterator listIterator() {
        return ListIteratorCharListIterator.wrap(this.getList().listIterator());
    }

    @Override
    @Nonnull
    public CharListIterator listIterator(int n) {
        return ListIteratorCharListIterator.wrap(this.getList().listIterator(n));
    }

    @Override
    public char removeElementAt(int n) {
        return this.getList().remove(n).charValue();
    }

    @Override
    public char set(int n, char c) {
        return this.getList().set(n, Character.valueOf(c)).charValue();
    }

    @Override
    @Nonnull
    public CharList subList(int n, int n2) {
        return ListCharList.wrap(this.getList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharList)) {
            return false;
        }
        CharList charList = (CharList)object;
        if (this.size() != charList.size()) {
            return false;
        }
        CharIterator charIterator = this.iterator();
        CharIterator charIterator2 = charList.iterator();
        while (charIterator.hasNext()) {
            if (charIterator.next() == charIterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }
}

