/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.CharList;
import org.apache.commons.collections.primitives.decorators.BaseUnmodifiableCharList;
import org.apache.commons.collections.primitives.decorators.NonSerializableUnmodifiableCharList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class UnmodifiableCharList
extends BaseUnmodifiableCharList
implements Serializable {
    private transient CharList m_aProxied;

    UnmodifiableCharList(@Nonnull CharList charList) {
        this.m_aProxied = charList;
    }

    @Override
    @Nonnull
    protected CharList getProxiedList() {
        return this.m_aProxied;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aProxied);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aProxied = (CharList)objectInputStream.readObject();
    }

    @Nullable
    public static final CharList wrap(@Nullable CharList charList) {
        if (null == charList) {
            return null;
        }
        if (charList instanceof UnmodifiableCharList) {
            return charList;
        }
        if (charList instanceof Serializable) {
            return new UnmodifiableCharList(charList);
        }
        return new NonSerializableUnmodifiableCharList(charList);
    }
}

