/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.FloatListIterator;
import org.apache.commons.collections.primitives.decorators.ProxyFloatListIterator;

public final class UnmodifiableFloatListIterator
extends ProxyFloatListIterator {
    private FloatListIterator m_aProxied;

    UnmodifiableFloatListIterator(@Nonnull FloatListIterator floatListIterator) {
        this.m_aProxied = floatListIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This FloatListIterator is not modifiable.");
    }

    @Override
    public void add(float f) {
        throw new UnsupportedOperationException("This FloatListIterator is not modifiable.");
    }

    @Override
    public void set(float f) {
        throw new UnsupportedOperationException("This FloatListIterator is not modifiable.");
    }

    @Override
    protected FloatListIterator getListIterator() {
        return this.m_aProxied;
    }

    @Nullable
    public static final FloatListIterator wrap(@Nullable FloatListIterator floatListIterator) {
        if (null == floatListIterator) {
            return null;
        }
        if (floatListIterator instanceof UnmodifiableFloatListIterator) {
            return floatListIterator;
        }
        return new UnmodifiableFloatListIterator(floatListIterator);
    }
}

