/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.decorators.BaseUnmodifiableLongList;
import org.apache.commons.collections.primitives.decorators.NonSerializableUnmodifiableLongList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class UnmodifiableLongList
extends BaseUnmodifiableLongList
implements Serializable {
    private transient LongList m_aProxied;

    UnmodifiableLongList(@Nonnull LongList longList) {
        this.m_aProxied = longList;
    }

    @Override
    @Nonnull
    protected LongList getProxiedList() {
        return this.m_aProxied;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aProxied);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aProxied = (LongList)objectInputStream.readObject();
    }

    @Nullable
    public static final LongList wrap(@Nullable LongList longList) {
        if (null == longList) {
            return null;
        }
        if (longList instanceof UnmodifiableLongList) {
            return longList;
        }
        if (longList instanceof Serializable) {
            return new UnmodifiableLongList(longList);
        }
        return new NonSerializableUnmodifiableLongList(longList);
    }
}

