/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.javasimon.Callback;
import org.javasimon.CompositeCallback;
import org.javasimon.Counter;
import org.javasimon.FilterCallback;
import org.javasimon.Simon;
import org.javasimon.SimonPattern;
import org.javasimon.Split;
import org.javasimon.Stopwatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeFilterCallback
implements FilterCallback {
    private CompositeCallback callback = new CompositeCallback();
    private Map<Callback.Event, List<FilterCallback.Rule>> rules = new EnumMap<Callback.Event, List<FilterCallback.Rule>>(Callback.Event.class);

    public CompositeFilterCallback() {
        for (Callback.Event event : Callback.Event.values()) {
            this.rules.put(event, new CopyOnWriteArrayList());
        }
    }

    @Override
    public List<Callback> callbacks() {
        return this.callback.callbacks();
    }

    @Override
    public void addCallback(Callback callback) {
        this.callback.addCallback(callback);
    }

    @Override
    public void removeCallback(Callback callback) {
        this.callback.removeCallback(callback);
    }

    @Override
    public void initialize() {
        this.callback.initialize();
    }

    @Override
    public void cleanup() {
        this.callback.cleanup();
    }

    @Override
    public void reset(Simon simon) {
        if (this.rulesAppliesTo(simon, Callback.Event.RESET, new Object[0])) {
            this.callback.reset(simon);
        }
    }

    @Override
    public void stopwatchAdd(Stopwatch stopwatch, long ns) {
        if (this.rulesAppliesTo(stopwatch, Callback.Event.STOPWATCH_ADD, ns)) {
            this.callback.stopwatchAdd(stopwatch, ns);
        }
    }

    @Override
    public void stopwatchStart(Split split) {
        if (this.rulesAppliesTo(split.getStopwatch(), Callback.Event.STOPWATCH_START, split)) {
            this.callback.stopwatchStart(split);
        }
    }

    @Override
    public void stopwatchStop(Split split) {
        if (this.rulesAppliesTo(split.getStopwatch(), Callback.Event.STOPWATCH_STOP, split)) {
            this.callback.stopwatchStop(split);
        }
    }

    @Override
    public void counterDecrease(Counter counter, long dec) {
        if (this.rulesAppliesTo(counter, Callback.Event.COUNTER_DECREASE, dec)) {
            this.callback.counterDecrease(counter, dec);
        }
    }

    @Override
    public void counterIncrease(Counter counter, long inc) {
        if (this.rulesAppliesTo(counter, Callback.Event.COUNTER_INCREASE, inc)) {
            this.callback.counterDecrease(counter, inc);
        }
    }

    @Override
    public void counterSet(Counter counter, long val) {
        if (this.rulesAppliesTo(counter, Callback.Event.COUNTER_SET, val)) {
            this.callback.counterDecrease(counter, val);
        }
    }

    @Override
    public void simonCreated(Simon simon) {
        if (this.rulesAppliesTo(simon, Callback.Event.CREATED, new Object[0])) {
            this.callback.simonCreated(simon);
        }
    }

    @Override
    public void simonDestroyed(Simon simon) {
        if (this.rulesAppliesTo(simon, Callback.Event.DESTROYED, new Object[0])) {
            this.callback.simonDestroyed(simon);
        }
    }

    @Override
    public void clear() {
        if (this.rulesAppliesTo(null, Callback.Event.CLEAR, new Object[0])) {
            this.callback.clear();
        }
    }

    @Override
    public void message(String message) {
        if (this.rulesAppliesTo(null, Callback.Event.MESSAGE, message)) {
            this.callback.message(message);
        }
    }

    @Override
    public void warning(String warning, Exception cause) {
        if (this.rulesAppliesTo(null, Callback.Event.WARNING, cause)) {
            this.callback.warning(warning, cause);
        }
    }

    @Override
    public void addRule(FilterCallback.Rule.Type type, String condition, String pattern, Callback.Event ... events) {
        SimonPattern simonPattern = null;
        if (pattern != null) {
            simonPattern = new SimonPattern(pattern);
        }
        FilterCallback.Rule rule = new FilterCallback.Rule(type, condition, simonPattern);
        for (Callback.Event event : events) {
            if (event == null) continue;
            this.rules.get((Object)event).add(rule);
        }
        if (events.length == 0) {
            this.rules.get((Object)Callback.Event.ALL).add(rule);
        }
    }

    private boolean rulesAppliesTo(Simon simon, Callback.Event checkedEvent, Object ... params) {
        for (Callback.Event event : new Callback.Event[]{checkedEvent, Callback.Event.ALL}) {
            for (FilterCallback.Rule rule : this.rules.get((Object)event)) {
                boolean result = this.patternAndConditionCheck(simon, rule, params);
                if (!result && rule.getType().equals((Object)FilterCallback.Rule.Type.MUST)) {
                    return false;
                }
                if (result && rule.getType().equals((Object)FilterCallback.Rule.Type.MUST_NOT)) {
                    return false;
                }
                if (!result || !rule.getType().equals((Object)FilterCallback.Rule.Type.SUFFICE)) continue;
                return true;
            }
        }
        return true;
    }

    private boolean patternAndConditionCheck(Simon simon, FilterCallback.Rule rule, Object ... params) {
        boolean result = true;
        if (simon != null && rule.getPattern() != null && !rule.getPattern().matches(simon.getName())) {
            result = false;
        }
        if (result && !rule.checkCondition(simon, params)) {
            result = false;
        }
        return result;
    }
}

