/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLHelper;
import org.nuxeo.ecm.directory.sql.SQLSession;
import org.nuxeo.ecm.directory.sql.SimpleDataSource;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SQLDirectory
extends AbstractDirectory {
    public static final Log log = LogFactory.getLog(SQLDirectory.class);
    public static final String TENANT_ID_FIELD = "tenantId";
    public static final int MAX_CONNECTION_TRIES = 5;
    private final SQLDirectoryDescriptor config;
    private final boolean nativeCase;
    private boolean managedSQLSession;
    private DataSource dataSource;
    private final Table table;
    private final Schema schema;
    private final Map<String, Field> schemaFieldMap;
    private final List<String> storedFieldNames;
    private final Dialect dialect;

    public SQLDirectory(SQLDirectoryDescriptor config) throws ClientException {
        super(config.name);
        this.config = config;
        this.nativeCase = Boolean.TRUE.equals(config.nativeCase);
        this.addReferences(config.getInverseReferences());
        this.addReferences(config.getTableReferences());
        this.cache.setMaxSize(config.getCacheMaxSize());
        this.cache.setTimeout(config.getCacheTimeout());
        Connection sqlConnection = this.getConnection();
        try {
            this.dialect = Dialect.createDialect((Connection)sqlConnection, null, null);
            if (config.initDependencies != null) {
                RuntimeService runtime = Framework.getRuntime();
                DirectoryServiceImpl directoryService = (DirectoryServiceImpl)runtime.getComponent(DirectoryService.NAME);
                for (String dependency : config.initDependencies) {
                    log.debug((Object)("initializing dependencies first: " + dependency));
                    Directory dir = directoryService.getDirectory(dependency);
                    dir.getName();
                }
            }
            this.table = SQLHelper.addTable(config.tableName, this.dialect, this.useNativeCase());
            SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
            this.schema = schemaManager.getSchema(config.schemaName);
            if (this.schema == null) {
                throw new DirectoryException("schema not found: " + config.schemaName);
            }
            this.schemaFieldMap = new LinkedHashMap<String, Field>();
            this.storedFieldNames = new LinkedList<String>();
            boolean hasPrimary = false;
            for (Field f : this.schema.getFields()) {
                String fieldName = f.getName().getLocalName();
                this.schemaFieldMap.put(fieldName, f);
                if (this.isReference(fieldName)) continue;
                this.storedFieldNames.add(fieldName);
                boolean isId = fieldName.equals(config.getIdField());
                ColumnType type = ColumnType.fromField((Field)f);
                if (isId && config.isAutoincrementIdField()) {
                    type = ColumnType.AUTOINC;
                }
                Column column = SQLHelper.addColumn(this.table, fieldName, type, this.useNativeCase());
                if (!isId) continue;
                if (config.isAutoincrementIdField()) {
                    column.setIdentity(true);
                }
                column.setPrimary(true);
                column.setNullable(false);
                hasPrimary = true;
            }
            if (!hasPrimary) {
                throw new DirectoryException(String.format("Directory '%s' id field '%s' is not present in schema '%s'", this.getName(), this.getIdField(), this.getSchema()));
            }
            SQLHelper helper = new SQLHelper(sqlConnection, this.table, config.dataFileName, config.getDataFileCharacterSeparator(), config.createTablePolicy);
            helper.setupTable();
            try {
                if (!this.managedSQLSession) {
                    sqlConnection.commit();
                }
            }
            catch (SQLException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        catch (StorageException e) {
            throw new DirectoryException((Throwable)e);
        }
        finally {
            try {
                sqlConnection.close();
            }
            catch (Exception e) {
                throw new DirectoryException((Throwable)e);
            }
        }
    }

    public SQLDirectoryDescriptor getConfig() {
        return this.config;
    }

    protected DataSource getDataSource() throws DirectoryException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        try {
            if (!StringUtils.isEmpty((String)this.config.dataSourceName)) {
                this.managedSQLSession = true;
                this.dataSource = DataSourceHelper.getDataSource((String)this.config.dataSourceName);
            } else {
                this.managedSQLSession = false;
                this.dataSource = new SimpleDataSource(this.config.dbUrl, this.config.dbDriver, this.config.dbUser, this.config.dbPassword);
            }
            log.trace((Object)("found datasource: " + this.dataSource));
            return this.dataSource;
        }
        catch (Exception e) {
            log.error((Object)"dataSource lookup failed", (Throwable)e);
            throw new DirectoryException("dataSource lookup failed", (Throwable)e);
        }
    }

    public Connection getConnection() throws DirectoryException {
        try {
            Connection connection;
            if (!StringUtils.isEmpty((String)this.config.dataSourceName) && (connection = ConnectionHelper.getConnection((String)this.config.dataSourceName)) != null) {
                this.managedSQLSession = true;
                return connection;
            }
            return this.getConnection(this.getDataSource());
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot connect to SQL directory '" + this.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected Connection getConnection(DataSource dataSource) throws SQLException {
        int tryNo = 0;
        while (true) {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException e) {
                if (tryNo >= 5) {
                    throw e;
                }
                if (e.getErrorCode() != 12519) {
                    throw e;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Connections open too fast, retrying in %ds: %s", tryNo, e.getMessage().replace("\n", " ")));
                }
                try {
                    Thread.sleep(1000 * tryNo);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new SQLException("interrupted");
                }
                ++tryNo;
                continue;
            }
            break;
        }
    }

    public String getName() {
        return this.config.getName();
    }

    public String getSchema() {
        return this.config.getSchemaName();
    }

    public String getParentDirectory() {
        return this.config.getParentDirectory();
    }

    public String getIdField() {
        return this.config.getIdField();
    }

    public String getPasswordField() {
        return this.config.getPasswordField();
    }

    public synchronized Session getSession() throws DirectoryException {
        SQLSession session = new SQLSession(this, this.config, this.managedSQLSession);
        this.addSession(session);
        return session;
    }

    protected synchronized void addSession(SQLSession session) throws DirectoryException {
        super.addSession((Session)session);
        this.registerInTx(session);
    }

    protected void registerInTx(SQLSession session) throws DirectoryException {
        if (!TransactionHelper.isTransactionActive()) {
            return;
        }
        try {
            ConnectionHelper.registerSynchronization((Synchronization)new TxSessionCleaner(session));
        }
        catch (SystemException e) {
            throw new DirectoryException("Cannot register in tx for session cleanup handling " + (Object)((Object)this), (Throwable)e);
        }
    }

    public Map<String, Field> getSchemaFieldMap() {
        return this.schemaFieldMap;
    }

    public List<String> getStoredFieldNames() {
        return this.storedFieldNames;
    }

    public Table getTable() {
        return this.table;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean useNativeCase() {
        return this.nativeCase;
    }

    public boolean isMultiTenant() {
        return this.table.getColumn(TENANT_ID_FIELD) != null;
    }

    public String toString() {
        return "SQLDirectory [name=" + this.config.name + "]";
    }

    protected class TxSessionCleaner
    implements Synchronization {
        private final SQLSession session;
        Throwable initContext = this.captureInitContext();

        protected TxSessionCleaner(SQLSession session) {
            this.session = session;
        }

        protected Throwable captureInitContext() {
            if (!log.isDebugEnabled()) {
                return null;
            }
            return new Throwable("SQL directory session init context in " + (Object)((Object)SQLDirectory.this));
        }

        protected void checkIsNotLive() {
            try {
                if (!this.session.isLive()) {
                    return;
                }
                if (this.initContext != null) {
                    log.warn((Object)("Closing a sql directory session for you " + (Object)((Object)this.session)), this.initContext);
                } else {
                    log.warn((Object)("Closing a sql directory session for you " + (Object)((Object)this.session)));
                }
                if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                    log.warn((Object)("Closing sql directory session outside a transaction" + (Object)((Object)this.session)));
                }
                this.session.close();
            }
            catch (DirectoryException e) {
                log.error((Object)("Cannot state on sql directory session before commit " + (Object)((Object)SQLDirectory.this)), (Throwable)e);
            }
        }

        public void beforeCompletion() {
            this.checkIsNotLive();
        }

        public void afterCompletion(int status) {
            this.checkIsNotLive();
        }
    }
}

