/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.runtime.api.Framework;

public class SQLHelper {
    private static final Log log = LogFactory.getLog(SQLHelper.class);
    public static final String SQL_NULL_MARKER = "__NULL__";
    private static final String SQL_SCRIPT_CHARSET = "UTF-8";
    private static final Object DIRECTORY_INIT_LOCK = new Object();
    private final Table table;
    private final String tableName;
    private final Connection connection;
    private final String policy;
    private final String dataFileName;
    protected final char characterSeparator;
    private JDBCLogger logger = new JDBCLogger("SQLDirectory");

    public SQLHelper(Connection connection, Table table, String dataFileName, char characterSeparator, String policy) {
        this.table = table;
        this.connection = connection;
        this.policy = policy;
        this.dataFileName = dataFileName;
        this.tableName = table.getPhysicalName();
        this.characterSeparator = characterSeparator;
    }

    public SQLHelper(Connection connection, Table table, String dataFileName, String policy) {
        this(connection, table, dataFileName, ',', policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupTable() throws DirectoryException {
        log.debug((Object)String.format("setting up table '%s', policy='%s'", this.tableName, this.policy));
        if (this.policy.equals("never")) {
            log.debug((Object)"policy='never', skipping setup");
            return false;
        }
        Object object = DIRECTORY_INIT_LOCK;
        synchronized (object) {
            boolean tableExists = this.tableExists();
            if (this.policy.equals("on_missing_columns") && tableExists) {
                if (this.hasMatchingColumns()) {
                    log.debug((Object)"policy='on_missing_columns' and all column matched, skipping sql setup script");
                    return false;
                }
                log.debug((Object)"policy='on_missing_columns' and some columns are missing");
                this.addMissingColumns();
                return true;
            }
            this.createTable(tableExists);
            if (this.dataFileName == null) {
                log.debug((Object)String.format("Table '%s': no data file found", this.tableName));
                return true;
            }
            this.loadData();
        }
        return true;
    }

    private void addMissingColumns() throws DirectoryException {
        try {
            Statement stmt = this.connection.createStatement();
            for (Column column : this.getMissingColumns(false)) {
                String alter = this.table.getAddColumnSql(column);
                if (this.logger.isLogEnabled()) {
                    this.logger.log(alter);
                }
                stmt.execute(alter);
            }
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("Table '%s' alteration failed: %s", this.table, e.getMessage()), (Throwable)e);
        }
    }

    private void createTable(boolean tableExists) throws DirectoryException {
        try {
            Statement stmt = this.connection.createStatement();
            if (tableExists) {
                String dropSql = this.table.getDropSql();
                if (this.logger.isLogEnabled()) {
                    this.logger.log(dropSql);
                }
                stmt.execute(dropSql);
            }
            String createSql = this.table.getCreateSql();
            if (this.logger.isLogEnabled()) {
                this.logger.log(createSql);
            }
            stmt.execute(createSql);
            for (String sql : this.table.getPostCreateSqls(null)) {
                if (this.logger.isLogEnabled()) {
                    this.logger.log(sql);
                }
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("Table '%s' creation failed: %s", this.table, e.getMessage()), (Throwable)e);
        }
    }

    public boolean hasMatchingColumns() {
        Set<Column> missingColumns = this.getMissingColumns(true);
        if (missingColumns == null || missingColumns.size() > 0) {
            return false;
        }
        log.debug((Object)String.format("all fields matched for table '%s'", this.tableName));
        return true;
    }

    public Set<Column> getMissingColumns(Boolean breakAtFirstMissing) {
        try {
            HashSet<Column> missingColumns = new HashSet<Column>();
            Set<String> columnNames = this.getPhysicalColumns();
            for (Column column : this.table.getColumns()) {
                String fieldName = column.getPhysicalName();
                if (columnNames.contains(fieldName)) continue;
                log.debug((Object)String.format("required field: %s is missing", fieldName));
                missingColumns.add(column);
                if (!breakAtFirstMissing.booleanValue()) continue;
                return null;
            }
            return missingColumns;
        }
        catch (SQLException e) {
            log.warn((Object)("error while introspecting table: " + this.tableName), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPhysicalColumns() throws SQLException {
        ResultSet rs = null;
        HashSet<String> columnNames = new HashSet<String>();
        try {
            DatabaseMetaData metadata = this.connection.getMetaData();
            rs = metadata.getColumns(null, "%", this.tableName, "%");
            while (rs.next()) {
                columnNames.add(rs.getString("COLUMN_NAME"));
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                log.warn((Object)"Error while trying to close result set", (Throwable)e);
            }
        }
        return columnNames;
    }

    private boolean tableExists() throws DirectoryException {
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            String schemaName = null;
            String productName = metaData.getDatabaseProductName();
            if ("Oracle".equals(productName)) {
                Statement st = this.connection.createStatement();
                String sql = "SELECT SYS_CONTEXT('USERENV', 'SESSION_USER') FROM DUAL";
                log.trace((Object)("SQL: " + sql));
                ResultSet rs = st.executeQuery(sql);
                rs.next();
                schemaName = rs.getString(1);
                log.trace((Object)("checking existing tables for oracle database, schema: " + schemaName));
                st.close();
            }
            ResultSet rs = metaData.getTables(null, schemaName, this.table.getPhysicalName(), new String[]{"TABLE"});
            boolean exists = rs.next();
            log.debug((Object)String.format("checking if table %s exists: %s", this.table.getPhysicalName(), exists));
            return exists;
        }
        catch (SQLException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    private static String formatColumnValues(String[] columnValues) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (columnValues != null) {
            int i = 0;
            ArrayList<String> values = new ArrayList<String>();
            for (String columnValue : columnValues) {
                values.add(i + ": " + columnValue);
                ++i;
            }
            buffer.append(StringUtils.join(values.iterator(), (String)", "));
        }
        buffer.append(']');
        return buffer.toString();
    }

    private void loadData() throws DirectoryException {
        log.debug((Object)("loading data file: " + this.dataFileName));
        CSVReader csvReader = null;
        String[] columnValues = null;
        Statement ps = null;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.dataFileName);
            if (is == null && (is = Framework.getResourceLoader().getResourceAsStream(this.dataFileName)) == null) {
                throw new DirectoryException("data file not found: " + this.dataFileName);
            }
            csvReader = new CSVReader((Reader)new InputStreamReader(is, SQL_SCRIPT_CHARSET), this.characterSeparator);
            String[] columnNames = csvReader.readNext();
            ArrayList<Column> columns = new ArrayList<Column>();
            Insert insert = new Insert(this.table);
            for (String columnName : columnNames) {
                String trimmedColumnName = columnName.trim();
                Column column = this.table.getColumn(trimmedColumnName);
                if (column == null) {
                    throw new DirectoryException("column not found: " + trimmedColumnName);
                }
                columns.add(this.table.getColumn(trimmedColumnName));
                insert.addColumn(column);
            }
            String insertSql = insert.getStatement();
            log.debug((Object)("insert statement: " + insertSql));
            ps = this.connection.prepareStatement(insertSql);
            while ((columnValues = csvReader.readNext()) != null) {
                String value;
                if (columnValues.length == 0 || columnValues.length == 1 && "".equals(columnValues[0])) continue;
                if (columnValues.length != columnNames.length) {
                    log.error((Object)("invalid column count while reading csv file: " + this.dataFileName + ", values: " + SQLHelper.formatColumnValues(columnValues)));
                    continue;
                }
                if (this.logger.isLogEnabled()) {
                    ArrayList<String> values = new ArrayList<String>(columnNames.length);
                    for (int i = 0; i < columnNames.length; ++i) {
                        value = columnValues[i];
                        if (SQL_NULL_MARKER.equals(value)) {
                            value = null;
                        }
                        values.add(value);
                    }
                    this.logger.logSQL(insertSql, values);
                }
                for (int i = 0; i < columnNames.length; ++i) {
                    Object v;
                    Column column = (Column)columns.get(i);
                    value = columnValues[i];
                    if (SQL_NULL_MARKER.equals(value)) {
                        v = null;
                    } else if (column.getType().spec == ColumnSpec.STRING) {
                        v = value;
                    } else if (column.getType().spec == ColumnSpec.BOOLEAN) {
                        v = Boolean.valueOf(value);
                    } else if (column.getType().spec == ColumnSpec.LONG) {
                        try {
                            v = Long.valueOf(value);
                        }
                        catch (NumberFormatException e) {
                            throw new DirectoryException(String.format("failed to set column '%s' on table '%s', values: %s", column.getPhysicalName(), this.table.getPhysicalName(), SQLHelper.formatColumnValues(columnValues)), (Throwable)e);
                        }
                    } else if (column.getType().spec == ColumnSpec.TIMESTAMP) {
                        try {
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime(Timestamp.valueOf(value));
                            v = cal;
                        }
                        catch (IllegalArgumentException e) {
                            throw new DirectoryException(String.format("failed to set column '%s' on table '%s', values: %s", column.getPhysicalName(), this.table.getPhysicalName(), SQLHelper.formatColumnValues(columnValues)), (Throwable)e);
                        }
                    } else if (column.getType().spec == ColumnSpec.DOUBLE) {
                        try {
                            v = Double.valueOf(value);
                        }
                        catch (NumberFormatException e) {
                            throw new DirectoryException(String.format("failed to set column '%s' on table '%s', values: %s", column.getPhysicalName(), this.table.getPhysicalName(), SQLHelper.formatColumnValues(columnValues)), (Throwable)e);
                        }
                    } else {
                        throw new DirectoryException("unrecognized column type: " + column.getType() + ", values: " + SQLHelper.formatColumnValues(columnValues));
                    }
                    column.setToPreparedStatement((PreparedStatement)ps, i + 1, (Serializable)v);
                }
                ps.execute();
            }
        }
        catch (IOException e) {
            throw new DirectoryException("Read error while reading data file: " + this.dataFileName, (Throwable)e);
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("Table '%s' initialization failed: %s, values: %s", this.table.getPhysicalName(), e.getMessage(), SQLHelper.formatColumnValues(columnValues)), (Throwable)e);
        }
        finally {
            try {
                if (csvReader != null) {
                    csvReader.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (IOException e) {
                throw new DirectoryException("Error closing data file: " + this.dataFileName, (Throwable)e);
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public static Table addTable(String name, Dialect dialect, boolean nativeCase) {
        String physicalName = dialect.getTableName(name);
        if (!nativeCase && name.length() == physicalName.length()) {
            physicalName = name;
        }
        return new TableImpl(dialect, physicalName, physicalName);
    }

    public static Column addColumn(Table table, String fieldName, ColumnType type, boolean nativeCase) {
        String physicalName = table.getDialect().getColumnName(fieldName);
        if (!nativeCase && fieldName.length() == physicalName.length()) {
            physicalName = fieldName;
        }
        Column column = new Column(table, physicalName, type, fieldName);
        return ((TableImpl)table).addColumn(fieldName, column);
    }
}

