/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.converter;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.picture.api.BlobHelper;
import org.nuxeo.runtime.api.Framework;

public class ThumbnailDocumentConverter
implements Converter {
    public static final String THUMBNAIL_CONVERTER_NAME = "toThumbnail";
    public static final String THUMBNAIL_SIZE_PARAMETER_NAME = "size";
    public static final String THUMBNAIL_DEFAULT_SIZE = "100x100";
    public static final String THUMBNAIL_COMMAND = "toThumbnail";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        File tmpFile = null;
        try {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CommandAvailability commandAvailability = cles.getCommandAvailability("toThumbnail");
            if (!commandAvailability.isAvailable()) {
                BlobHolder blobHolder2 = null;
                return blobHolder2;
            }
            Blob blob = blobHolder.getBlob();
            blob.persist();
            File inputFile = BlobHelper.getFileFromBlob((Blob)blob);
            if (inputFile == null) {
                tmpFile = File.createTempFile("nuxeoImageInfo", ".tmp");
                blob.transferTo(tmpFile);
                inputFile = tmpFile;
            }
            CmdParameters params = new CmdParameters();
            File outputFile = File.createTempFile("nuxeoImageTarget", ".png");
            String size = THUMBNAIL_DEFAULT_SIZE;
            if (parameters != null && parameters.containsKey(THUMBNAIL_SIZE_PARAMETER_NAME)) {
                size = (String)((Object)parameters.get(THUMBNAIL_SIZE_PARAMETER_NAME));
            }
            params.addNamedParameter(THUMBNAIL_SIZE_PARAMETER_NAME, size);
            params.addNamedParameter("inputFilePath", inputFile);
            params.addNamedParameter("outputFilePath", outputFile);
            ExecResult res = cles.execCommand("toThumbnail", params);
            if (!res.isSuccessful()) {
                throw res.getError();
            }
            FileBlob targetBlob = new FileBlob(outputFile);
            Framework.trackFile((File)outputFile, (Object)targetBlob);
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)targetBlob);
            return simpleCachableBlobHolder;
        }
        catch (IOException | ClientException | CommandException | CommandNotAvailable e) {
            throw new ConversionException("Thumbnail conversion failed", (Exception)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

