/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.listener;

import java.io.Serializable;
import java.util.HashSet;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailAdapter;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.thumbnail.ThumbnailConstants;

public class UpdateThumbnailListener
implements PostCommitEventListener {
    protected void processDoc(CoreSession session, DocumentModel doc) throws ClientException {
        ThumbnailAdapter thumbnailAdapter = (ThumbnailAdapter)doc.getAdapter(ThumbnailAdapter.class);
        if (thumbnailAdapter == null) {
            return;
        }
        Blob thumbnailBlob = thumbnailAdapter.computeThumbnail(session);
        if (thumbnailBlob != null) {
            if (!doc.hasFacet("Thumbnail")) {
                doc.addFacet("Thumbnail");
            }
            doc.setPropertyValue("thumb:thumbnail", (Serializable)thumbnailBlob);
        } else if (doc.hasFacet("Thumbnail")) {
            doc.setPropertyValue("thumb:thumbnail", null);
            doc.removeFacet("Thumbnail");
        }
        if (doc.isDirty()) {
            doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
            doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
            doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
            doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
            doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
            if (doc.isVersion()) {
                doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            session.saveDocument(doc);
        }
    }

    public void handleEvent(EventBundle events) throws ClientException {
        if (!events.containsEventName(ThumbnailConstants.EventNames.scheduleThumbnailUpdate.name())) {
            return;
        }
        HashSet<String> processedDocs = new HashSet<String>();
        for (Event event : events) {
            DocumentEventContext context;
            DocumentModel doc;
            if (!ThumbnailConstants.EventNames.scheduleThumbnailUpdate.name().equals(event.getName()) || (doc = (context = (DocumentEventContext)event.getContext()).getSourceDocument()) instanceof DeletedDocumentModel || doc.isProxy() || processedDocs.contains(doc.getId())) continue;
            CoreSession repo = context.getCoreSession();
            this.processDoc(repo, doc);
            processedDocs.add(doc.getId());
        }
    }
}

