/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Environment {
    private static Log logger = LogFactory.getLog(Environment.class);
    public static final String JBOSS_HOST = "JBoss";
    public static final String NXSERVER_HOST = "NXServer";
    public static final String TOMCAT_HOST = "Tomcat";
    public static final String NUXEO_HOME_DIR = "nuxeo.home.dir";
    public static final String NUXEO_HOME = "nuxeo.home";
    public static final String NUXEO_RUNTIME_HOME = "nuxeo.runtime.home";
    public static final String NUXEO_DATA_DIR = "nuxeo.data.dir";
    public static final String DEFAULT_DATA_DIR = "data";
    public static final String NUXEO_LOG_DIR = "nuxeo.log.dir";
    public static final String DEFAULT_LOG_DIR = "log";
    public static final String NUXEO_PID_DIR = "nuxeo.pid.dir";
    public static final String NUXEO_TMP_DIR = "nuxeo.tmp.dir";
    public static final String DEFAULT_TMP_DIR = "tmp";
    public static final String NUXEO_CONFIG_DIR = "nuxeo.config.dir";
    public static final String DEFAULT_CONFIG_DIR = "config";
    public static final String NUXEO_WEB_DIR = "nuxeo.web.dir";
    public static final String DEFAULT_WEB_DIR = "web";
    public static final String NUXEO_MP_DIR = "nuxeo.mp.dir";
    public static final String DEFAULT_MP_DIR = "packages";
    public static final String NUXEO_CONTEXT_PATH = "org.nuxeo.ecm.contextPath";
    @Deprecated
    public static final String HOME_DIR = "org.nuxeo.app.home";
    @Deprecated
    public static final String WEB_DIR = "org.nuxeo.app.web";
    @Deprecated
    public static final String CONFIG_DIR = "org.nuxeo.app.config";
    @Deprecated
    public static final String DATA_DIR = "org.nuxeo.app.data";
    @Deprecated
    public static final String LOG_DIR = "org.nuxeo.app.log";
    public static final String BUNDLES_DIR = "nuxeo.osgi.app.bundles";
    public static final String BUNDLES = "nuxeo.osgi.bundles";
    private static volatile Environment DEFAULT;
    protected final File home;
    protected File data;
    protected File log;
    protected File config;
    protected File web;
    protected File temp;
    protected final Properties properties;
    protected String[] args;
    protected boolean isAppServer;
    protected String hostAppName;
    protected String hostAppVersion;
    protected Iterable<URL> configProvider;
    private File serverHome = null;
    private File runtimeHome;
    public static final String DISTRIBUTION_NAME = "org.nuxeo.distribution.name";
    public static final String DISTRIBUTION_VERSION = "org.nuxeo.distribution.version";

    public Environment(File home) {
        this(home, null);
    }

    public Environment(File home, Properties properties) {
        this.home = home;
        this.properties = new Properties();
        if (properties != null) {
            this.loadProperties(properties);
        }
        this.properties.put(HOME_DIR, this.home.getAbsolutePath());
    }

    public static synchronized void setDefault(Environment env) {
        DEFAULT = env;
    }

    public static Environment getDefault() {
        if (DEFAULT == null) {
            Environment.tryInitEnvironment();
        }
        return DEFAULT;
    }

    private static synchronized void tryInitEnvironment() {
        File home;
        String homeDir = System.getProperty(NUXEO_HOME);
        if (homeDir != null && (home = new File(homeDir)).isDirectory()) {
            DEFAULT = new Environment(home);
        }
    }

    public File getHome() {
        return this.home;
    }

    public boolean isApplicationServer() {
        return this.isAppServer;
    }

    public void setIsApplicationServer(boolean isAppServer) {
        this.isAppServer = isAppServer;
    }

    public String getHostApplicationName() {
        return this.hostAppName;
    }

    public String getHostApplicationVersion() {
        return this.hostAppVersion;
    }

    public void setHostApplicationName(String name) {
        this.hostAppName = name;
    }

    public void setHostApplicationVersion(String version) {
        this.hostAppVersion = version;
    }

    public File getTemp() {
        if (this.temp == null) {
            this.temp = new File(this.home, DEFAULT_TMP_DIR);
        }
        return this.temp;
    }

    public void setTemp(File temp) {
        this.temp = temp;
        this.properties.put(NUXEO_TMP_DIR, temp.getAbsolutePath());
    }

    public File getConfig() {
        if (this.config == null) {
            this.config = new File(this.home, DEFAULT_CONFIG_DIR);
        }
        return this.config;
    }

    public void setConfig(File config) {
        this.config = config;
        this.properties.put(NUXEO_CONFIG_DIR, config.getAbsolutePath());
    }

    public File getLog() {
        if (this.log == null) {
            this.log = new File(this.home, DEFAULT_LOG_DIR);
        }
        return this.log;
    }

    public void setLog(File log) {
        this.log = log;
        this.properties.put(NUXEO_LOG_DIR, log.getAbsolutePath());
    }

    public File getData() {
        if (this.data == null) {
            this.data = new File(this.home, DEFAULT_DATA_DIR);
        }
        return this.data;
    }

    public void setData(File data) {
        this.data = data;
        this.properties.put(NUXEO_DATA_DIR, data.getAbsolutePath());
    }

    public File getWeb() {
        if (this.web == null) {
            this.web = new File(this.home, DEFAULT_WEB_DIR);
        }
        return this.web;
    }

    public void setWeb(File web) {
        this.web = web;
        this.properties.put(NUXEO_WEB_DIR, web.getAbsolutePath());
    }

    public File getRuntimeHome() {
        if (this.runtimeHome == null) {
            this.initRuntimeHome();
        }
        return this.runtimeHome;
    }

    public void setRuntimeHome(File runtimeHome) {
        this.runtimeHome = runtimeHome;
        this.properties.put(NUXEO_RUNTIME_HOME, runtimeHome.getAbsolutePath());
    }

    public String[] getCommandLineArguments() {
        return this.args;
    }

    public void setCommandLineArguments(String[] args) {
        this.args = args;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.properties.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void loadProperties(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
    }

    public boolean isJBoss() {
        return JBOSS_HOST.equals(this.hostAppName);
    }

    public boolean isJetty() {
        return NXSERVER_HOST.equals(this.hostAppName);
    }

    public boolean isTomcat() {
        return TOMCAT_HOST.equals(this.hostAppName);
    }

    public void init() {
        String dataDir = System.getProperty(NUXEO_DATA_DIR);
        String configDir = System.getProperty(NUXEO_CONFIG_DIR);
        String logDir = System.getProperty(NUXEO_LOG_DIR);
        String tmpDir = System.getProperty(NUXEO_TMP_DIR);
        String mpDir = System.getProperty(NUXEO_MP_DIR);
        this.initServerHome();
        this.initRuntimeHome();
        if (StringUtils.isNotEmpty((String)dataDir)) {
            this.setData(new File(dataDir));
        }
        if (StringUtils.isNotEmpty((String)configDir)) {
            this.setConfig(new File(configDir));
        }
        if (StringUtils.isNotEmpty((String)logDir)) {
            this.setLog(new File(logDir));
        }
        if (StringUtils.isNotEmpty((String)tmpDir)) {
            this.setTemp(new File(tmpDir));
        }
        if (StringUtils.isNotEmpty((String)mpDir)) {
            this.properties.put(NUXEO_MP_DIR, mpDir);
        }
    }

    private void initRuntimeHome() {
        String runtimeDir = System.getProperty(NUXEO_RUNTIME_HOME);
        this.runtimeHome = runtimeDir != null && !runtimeDir.isEmpty() ? new File(runtimeDir) : this.home;
    }

    public File getServerHome() {
        if (this.serverHome == null) {
            this.initServerHome();
        }
        return this.serverHome;
    }

    public void setServerHome(File serverHome) {
        this.serverHome = serverHome;
        this.properties.put(NUXEO_HOME_DIR, serverHome.getAbsolutePath());
    }

    private void initServerHome() {
        String homeDir = System.getProperty(NUXEO_HOME, System.getProperty(NUXEO_HOME_DIR));
        if (homeDir != null && !homeDir.isEmpty()) {
            this.serverHome = new File(homeDir);
        } else {
            logger.warn((Object)String.format("Could not get %s neither %s system properties, will use %s", NUXEO_HOME, NUXEO_HOME_DIR, this.home));
            this.serverHome = this.home;
        }
        logger.debug((Object)this);
    }

    public void setConfigurationProvider(Iterable<URL> configProvider) {
        this.configProvider = configProvider;
    }

    public Iterable<URL> getConfigurationProvider() {
        return this.configProvider;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

