/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.Serializable;

public class Path
implements Serializable {
    private static final long serialVersionUID = -5420562131803786641L;
    private static final int HAS_LEADING = 1;
    private static final int HAS_TRAILING = 2;
    private static final int ALL_SEPARATORS = 3;
    private static final int USED_BITS = 2;
    private static final String[] NO_SEGMENTS = new String[0];
    private static final char SEPARATOR = '/';
    private static final String EMPTY_STRING = "";
    private static final Path EMPTY = new Path("");
    private static final int HASH_MASK = -3;
    private static final String ROOT_STRING = "/";
    private static final Path ROOT = new Path("/");
    private String[] segments;
    private int separators;

    public Path(String fullPath) {
        this.initialize(fullPath);
    }

    private Path(String[] segments, int separators) {
        this.segments = segments;
        this.separators = this.computeHashCode() << 2 | separators & 3;
    }

    public static Path createFromAbsolutePath(String path) {
        assert (path != null);
        int len = Path.computeSegmentCount(path);
        if (path.length() < 2) {
            return ROOT;
        }
        String[] segments = new String[len];
        int k = 0;
        int j = 1;
        int i = path.indexOf(47, j);
        while (i > 0) {
            segments[k++] = path.substring(j, i);
            j = i + 1;
            i = path.indexOf(47, j);
        }
        segments[k] = path.substring(j);
        return new Path(segments, 1);
    }

    public static Path createFromSegments(String[] segments) {
        if (segments.length == 0) {
            return ROOT;
        }
        return new Path(segments, 1);
    }

    public Path addFileExtension(String extension) {
        if (this.isRoot() || this.isEmpty() || this.hasTrailingSeparator()) {
            return this;
        }
        int len = this.segments.length;
        String[] newSegments = new String[len];
        System.arraycopy(this.segments, 0, newSegments, 0, len - 1);
        newSegments[len - 1] = this.segments[len - 1] + '.' + extension;
        return new Path(newSegments, this.separators);
    }

    public Path addTrailingSeparator() {
        if (this.hasTrailingSeparator() || this.isRoot()) {
            return this;
        }
        if (this.isEmpty()) {
            return new Path(this.segments, 1);
        }
        return new Path(this.segments, this.separators | 2);
    }

    public Path append(Path tail) {
        if (tail == null || tail.segmentCount() == 0) {
            return this;
        }
        if (this.isEmpty()) {
            return tail.makeRelative();
        }
        if (this.isRoot()) {
            return tail.makeAbsolute();
        }
        int myLen = this.segments.length;
        int tailLen = tail.segmentCount();
        String[] newSegments = new String[myLen + tailLen];
        System.arraycopy(this.segments, 0, newSegments, 0, myLen);
        for (int i = 0; i < tailLen; ++i) {
            newSegments[myLen + i] = tail.segment(i);
        }
        Path result = new Path(newSegments, this.separators & 1 | (tail.hasTrailingSeparator() ? 2 : 0));
        String tailFirstSegment = newSegments[myLen];
        if (tailFirstSegment.equals("..") || tailFirstSegment.equals(".")) {
            result.canonicalize();
        }
        return result;
    }

    public Path append(String tail) {
        if (tail.indexOf(47) == -1) {
            int tailLength = tail.length();
            if (tailLength < 3) {
                if (tailLength == 0 || ".".equals(tail)) {
                    return this;
                }
                if ("..".equals(tail)) {
                    return this.removeLastSegments(1);
                }
            }
            int myLen = this.segments.length;
            String[] newSegments = new String[myLen + 1];
            System.arraycopy(this.segments, 0, newSegments, 0, myLen);
            newSegments[myLen] = tail;
            return new Path(newSegments, this.separators & 0xFFFFFFFD);
        }
        return this.append(new Path(tail));
    }

    private boolean canonicalize() {
        for (String segment : this.segments) {
            if (segment.charAt(0) != '.' || !segment.equals("..") && !segment.equals(".")) continue;
            this.collapseParentReferences();
            if (this.segments.length == 0) {
                this.separators &= 1;
            }
            this.separators = this.separators & 3 | this.computeHashCode() << 2;
            return true;
        }
        return false;
    }

    private void collapseParentReferences() {
        int segmentCount = this.segments.length;
        String[] stack = new String[segmentCount];
        int stackPointer = 0;
        for (int i = 0; i < segmentCount; ++i) {
            String segment = this.segments[i];
            if (segment.equals("..")) {
                if (stackPointer == 0) {
                    if (this.isAbsolute()) continue;
                    stack[stackPointer++] = segment;
                    continue;
                }
                if ("..".equals(stack[stackPointer - 1])) {
                    stack[stackPointer++] = "..";
                    continue;
                }
                --stackPointer;
                continue;
            }
            if (segment.equals(".") && (i != 0 || this.isAbsolute())) continue;
            stack[stackPointer++] = segment;
        }
        if (stackPointer == segmentCount) {
            return;
        }
        String[] newSegments = new String[stackPointer];
        System.arraycopy(stack, 0, newSegments, 0, stackPointer);
        this.segments = newSegments;
    }

    private static String collapseSlashes(String path) {
        char[] characters;
        int length = path.length();
        if (length < 2) {
            return path;
        }
        if (path.indexOf("//", 1) == -1) {
            return path;
        }
        char[] result = new char[path.length()];
        int count = 0;
        boolean hasPrevious = false;
        for (char c : characters = path.toCharArray()) {
            if (c == '/') {
                if (hasPrevious) continue;
                hasPrevious = true;
                result[count] = c;
                ++count;
                continue;
            }
            hasPrevious = false;
            result[count] = c;
            ++count;
        }
        return new String(result, 0, count);
    }

    private int computeHashCode() {
        int hash = 17;
        int segmentCount = this.segments.length;
        for (int i = 0; i < segmentCount; ++i) {
            hash = hash * 37 + this.segments[i].hashCode();
        }
        return hash;
    }

    private int computeLength() {
        int max;
        int length = 0;
        if ((this.separators & 1) != 0) {
            ++length;
        }
        if ((max = this.segments.length) > 0) {
            for (int i = 0; i < max; ++i) {
                length += this.segments[i].length();
            }
            length += max - 1;
        }
        if ((this.separators & 2) != 0) {
            ++length;
        }
        return length;
    }

    private static int computeSegmentCount(String path) {
        int i;
        int len = path.length();
        if (len == 0 || len == 1 && path.charAt(0) == '/') {
            return 0;
        }
        int count = 1;
        int prev = -1;
        while ((i = path.indexOf(47, prev + 1)) != -1) {
            if (i != prev + 1 && i != len) {
                ++count;
            }
            prev = i;
        }
        if (path.charAt(len - 1) == '/') {
            --count;
        }
        return count;
    }

    private static String[] computeSegments(String path) {
        int firstPosition;
        int segmentCount = Path.computeSegmentCount(path);
        if (segmentCount == 0) {
            return NO_SEGMENTS;
        }
        String[] newSegments = new String[segmentCount];
        int len = path.length();
        int n = firstPosition = path.charAt(0) == '/' ? 1 : 0;
        if (firstPosition == 1 && len > 1 && path.charAt(1) == '/') {
            firstPosition = 2;
        }
        int lastPosition = path.charAt(len - 1) != '/' ? len - 1 : len - 2;
        int next = firstPosition;
        for (int i = 0; i < segmentCount; ++i) {
            int start = next;
            int end = path.indexOf(47, next);
            newSegments[i] = end == -1 ? path.substring(start, lastPosition + 1) : path.substring(start, end);
            next = end + 1;
        }
        return newSegments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path target = (Path)obj;
        if ((this.separators & 0xFFFFFFFD) != (target.separators & 0xFFFFFFFD)) {
            return false;
        }
        int i = this.segments.length;
        String[] targetSegments = target.segments;
        if (i != targetSegments.length) {
            return false;
        }
        while (--i >= 0) {
            if (this.segments[i].equals(targetSegments[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.separators & 0xFFFFFFFD;
    }

    public String getFileExtension() {
        if (this.hasTrailingSeparator()) {
            return null;
        }
        String lastSegment = this.lastSegment();
        if (lastSegment == null) {
            return null;
        }
        int index = lastSegment.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return lastSegment.substring(index + 1);
    }

    public boolean hasTrailingSeparator() {
        return (this.separators & 2) != 0;
    }

    private Path initialize(String path) {
        assert (path != null);
        int len = (path = Path.collapseSlashes(path)).length();
        if (len < 2) {
            this.separators = len == 1 && path.charAt(0) == '/' ? 1 : 0;
        } else {
            boolean hasLeading = path.charAt(0) == '/';
            boolean hasTrailing = path.charAt(len - 1) == '/';
            int n = this.separators = hasLeading ? 1 : 0;
            if (hasTrailing) {
                this.separators |= 2;
            }
        }
        this.segments = Path.computeSegments(path);
        if (!this.canonicalize()) {
            this.separators = this.separators & 3 | this.computeHashCode() << 2;
        }
        return this;
    }

    public boolean isAbsolute() {
        return (this.separators & 1) != 0;
    }

    public boolean isEmpty() {
        return this.segments.length == 0 && (this.separators & 3) != 1;
    }

    public boolean isPrefixOf(Path anotherPath) {
        if (this.isEmpty() || this.isRoot() && anotherPath.isAbsolute()) {
            return true;
        }
        int len = this.segments.length;
        if (len > anotherPath.segmentCount()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.segments[i].equals(anotherPath.segment(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        return this == ROOT || this.segments.length == 0 && (this.separators & 3) == 1;
    }

    public static boolean isValidPath(String path) {
        Path test = new Path(path);
        int max = test.segmentCount();
        for (int i = 0; i < max; ++i) {
            if (Path.isValidSegment(test.segment(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidSegment(String segment) {
        int size = segment.length();
        if (size == 0) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            char c = segment.charAt(i);
            if (c != '/') continue;
            return false;
        }
        return true;
    }

    public String lastSegment() {
        int len = this.segments.length;
        return len == 0 ? null : this.segments[len - 1];
    }

    public Path makeAbsolute() {
        String first;
        if (this.isAbsolute()) {
            return this;
        }
        Path result = new Path(this.segments, this.separators | 1);
        if (result.segmentCount() > 0 && ((first = result.segment(0)).equals("..") || first.equals("."))) {
            result.canonicalize();
        }
        return result;
    }

    public Path makeRelative() {
        if (!this.isAbsolute()) {
            return this;
        }
        return new Path(this.segments, this.separators & 2);
    }

    public int matchingFirstSegments(Path anotherPath) {
        assert (anotherPath != null);
        int anotherPathLen = anotherPath.segmentCount();
        int max = Math.min(this.segments.length, anotherPathLen);
        int count = 0;
        for (int i = 0; i < max; ++i) {
            if (!this.segments[i].equals(anotherPath.segment(i))) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public Path removeFileExtension() {
        String extension = this.getFileExtension();
        if (extension == null || extension.equals(EMPTY_STRING)) {
            return this;
        }
        String lastSegment = this.lastSegment();
        int index = lastSegment.lastIndexOf(extension) - 1;
        return this.removeLastSegments(1).append(lastSegment.substring(0, index));
    }

    public Path removeFirstSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.segments.length) {
            return new Path(NO_SEGMENTS, 0);
        }
        assert (count > 0);
        int newSize = this.segments.length - count;
        String[] newSegments = new String[newSize];
        System.arraycopy(this.segments, count, newSegments, 0, newSize);
        return new Path(newSegments, this.separators & 2);
    }

    public Path removeLastSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.segments.length) {
            return new Path(NO_SEGMENTS, this.separators & 1);
        }
        assert (count > 0);
        int newSize = this.segments.length - count;
        String[] newSegments = new String[newSize];
        System.arraycopy(this.segments, 0, newSegments, 0, newSize);
        return new Path(newSegments, this.separators);
    }

    public Path removeTrailingSeparator() {
        if (!this.hasTrailingSeparator()) {
            return this;
        }
        return new Path(this.segments, this.separators & 1);
    }

    public String segment(int index) {
        if (index >= this.segments.length) {
            return null;
        }
        return this.segments[index];
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public String[] segments() {
        String[] segmentCopy = new String[this.segments.length];
        System.arraycopy(this.segments, 0, segmentCopy, 0, this.segments.length);
        return segmentCopy;
    }

    public String toString() {
        int len;
        int resultSize = this.computeLength();
        if (resultSize <= 0) {
            return EMPTY_STRING;
        }
        char[] result = new char[resultSize];
        int offset = 0;
        if ((this.separators & 1) != 0) {
            result[offset++] = 47;
        }
        if ((len = this.segments.length - 1) >= 0) {
            for (int i = 0; i < len; ++i) {
                int size = this.segments[i].length();
                this.segments[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = 47;
            }
            int size = this.segments[len].length();
            this.segments[len].getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.separators & 2) != 0) {
            result[offset] = 47;
        }
        return new String(result);
    }

    public Path uptoSegment(int count) {
        if (count == 0) {
            return new Path(NO_SEGMENTS, this.separators & 1);
        }
        if (count >= this.segments.length) {
            return this;
        }
        assert (count > 0);
        String[] newSegments = new String[count];
        System.arraycopy(this.segments, 0, newSegments, 0, count);
        return new Path(newSegments, this.separators);
    }

    public static String getFileNameFromPath(String iconPath) {
        int firstCharOfIconName = iconPath.lastIndexOf(47);
        int lastCharOfIconName = iconPath.lastIndexOf(".");
        String iconName = firstCharOfIconName == -1 ? iconPath : iconPath.substring(firstCharOfIconName, lastCharOfIconName);
        return iconName;
    }
}

