/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.nuxeo.runtime.datasource.DataSourceDescriptor;
import org.nuxeo.runtime.datasource.DataSourceLinkDescriptor;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DataSourceComponent
extends DefaultComponent {
    private final Log log = LogFactory.getLog(DataSourceComponent.class);
    public static final String DATASOURCES_XP = "datasources";
    public static final String ENV_CTX_NAME = "java:comp/env/";
    protected final Map<String, DataSourceDescriptor> datasources = new HashMap<String, DataSourceDescriptor>();
    protected final Map<String, DataSourceLinkDescriptor> links = new HashMap<String, DataSourceLinkDescriptor>();
    protected final PooledDataSourceRegistry registry = new PooledDataSourceRegistry();
    protected InitialContext namingContext;

    public void registerContribution(Object contrib, String extensionPoint, ComponentInstance component) throws Exception {
        if (DATASOURCES_XP.equals(extensionPoint)) {
            if (contrib instanceof DataSourceDescriptor) {
                this.addDataSource((DataSourceDescriptor)contrib);
            } else if (contrib instanceof DataSourceLinkDescriptor) {
                this.addDataSourceLink((DataSourceLinkDescriptor)contrib);
            } else {
                this.log.error((Object)("Wrong datasource extension type " + contrib.getClass().getName()));
            }
        } else {
            this.log.error((Object)("Ignoring unknown extension point: " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contrib, String extensionPoint, ComponentInstance component) throws Exception {
        if (DATASOURCES_XP.equals(extensionPoint)) {
            if (contrib instanceof DataSourceDescriptor) {
                this.removeDataSource((DataSourceDescriptor)contrib);
            } else if (contrib instanceof DataSourceLinkDescriptor) {
                this.removeDataSourceLink((DataSourceLinkDescriptor)contrib);
            }
        }
    }

    public int getApplicationStartedOrder() {
        return -1000;
    }

    public boolean isStarted() {
        return this.namingContext != null;
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        if (this.namingContext != null) {
            return;
        }
        this.namingContext = new InitialContext();
        CompositeName comp = new CompositeName(DataSourceHelper.getDataSourceJNDIPrefix());
        Context ctx = this.namingContext;
        for (int i = 0; i < comp.size(); ++i) {
            try {
                ctx = (Context)ctx.lookup(comp.get(i));
                continue;
            }
            catch (NamingException e) {
                ctx = ctx.createSubcontext(comp.get(i));
            }
        }
        for (DataSourceDescriptor datasourceDesc : this.datasources.values()) {
            this.bindDataSource(datasourceDesc);
        }
        for (DataSourceLinkDescriptor linkDesc : this.links.values()) {
            this.bindDataSourceLink(linkDesc);
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        for (DataSourceLinkDescriptor dataSourceLinkDescriptor : this.links.values()) {
            this.log.warn((Object)(dataSourceLinkDescriptor.name + " datasource link still referenced"));
            this.unbindDataSourceLink(dataSourceLinkDescriptor);
        }
        this.links.clear();
        for (DataSourceDescriptor dataSourceDescriptor : this.datasources.values()) {
            this.log.warn((Object)(dataSourceDescriptor.name + " datasource still referenced"));
            this.unbindDataSource(dataSourceDescriptor);
        }
        this.datasources.clear();
        this.namingContext = null;
    }

    protected void addDataSource(DataSourceDescriptor contrib) throws NamingException {
        this.datasources.put(contrib.name, contrib);
        this.bindDataSource(contrib);
    }

    protected void removeDataSource(DataSourceDescriptor contrib) throws NamingException {
        this.unbindDataSource(contrib);
        this.datasources.remove(contrib.name);
    }

    protected void bindDataSource(DataSourceDescriptor descr) {
        if (this.namingContext == null) {
            return;
        }
        this.log.info((Object)("Registering datasource: " + descr.name));
        try {
            descr.bindSelf(this.namingContext);
        }
        catch (NamingException e) {
            this.log.error((Object)("Cannot bind datasource '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }

    protected void unbindDataSource(DataSourceDescriptor descr) {
        if (this.namingContext == null) {
            return;
        }
        this.log.info((Object)("Unregistering datasource: " + descr.name));
        try {
            descr.unbindSelf(this.namingContext);
        }
        catch (NamingException cause) {
            this.log.error((Object)("Cannot unbind datasource '" + descr.name + "' in JNDI"), (Throwable)cause);
        }
    }

    protected void addDataSourceLink(DataSourceLinkDescriptor contrib) {
        this.links.put(contrib.name, contrib);
        this.bindDataSourceLink(contrib);
    }

    protected void removeDataSourceLink(DataSourceLinkDescriptor contrib) {
        this.unbindDataSourceLink(contrib);
        this.links.remove(contrib.name);
    }

    protected void bindDataSourceLink(DataSourceLinkDescriptor descr) {
        if (this.namingContext == null) {
            return;
        }
        this.log.info((Object)("Registering DataSourceLink: " + descr.name));
        try {
            descr.bindSelf(this.namingContext);
        }
        catch (NamingException e) {
            this.log.error((Object)("Cannot bind DataSourceLink '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }

    protected void unbindDataSourceLink(DataSourceLinkDescriptor descr) {
        if (this.namingContext == null) {
            return;
        }
        this.log.info((Object)("Unregistering DataSourceLink: " + descr.name));
        try {
            descr.unbindSelf(this.namingContext);
        }
        catch (NamingException e) {
            this.log.error((Object)("Cannot unbind DataSourceLink '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(PooledDataSourceRegistry.class)) {
            return adapter.cast(this.registry);
        }
        return (T)super.getAdapter(adapter);
    }
}

