/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.tomcat.jdbc.naming.GenericNamingResourcesFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@XObject(value="datasource")
public class DataSourceDescriptor {
    protected String name;
    @XNode(value="@xaDataSource")
    protected String xaDataSource;
    @XNode(value="@driverClassName")
    protected String driverClasssName;
    @XNode(value="")
    public Element element;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> properties;
    protected Reference poolReference;
    protected Reference xaReference;

    @XNode(value="@name")
    public void setName(String value) {
        this.name = value;
    }

    public void bindSelf(Context initialContext) throws NamingException {
        StringRefAddr addr;
        String value;
        if (this.xaDataSource != null) {
            String xaName = DataSourceHelper.getDataSourceJNDIName((String)(this.name + "-xa"));
            this.poolReference = new Reference(XADataSource.class.getName(), PoolFactory.class.getName(), null);
            this.poolReference.add(new StringRefAddr("dataSourceJNDI", xaName));
            this.xaReference = new Reference(this.xaDataSource, GenericNamingResourcesFactory.class.getName(), null);
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                String key = e.getKey();
                value = Framework.expandVars((String)e.getValue());
                addr = new StringRefAddr(key, value);
                this.xaReference.add(addr);
            }
            initialContext.bind(DataSourceHelper.getDataSourceJNDIName((String)xaName), (Object)this.xaReference);
        } else if (this.driverClasssName != null) {
            this.poolReference = new Reference(DataSource.class.getName(), PoolFactory.class.getName(), null);
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                String key = e.getKey();
                String value2 = Framework.expandVars((String)e.getValue());
                StringRefAddr addr2 = new StringRefAddr(key, value2);
                this.poolReference.add(addr2);
            }
        } else {
            throw new RuntimeException("Datasource " + this.name + " should have xaDataSource or driverClassName attribute");
        }
        NamedNodeMap attrs = this.element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String attrName = attr.getNodeName();
            value = Framework.expandVars((String)attr.getNodeValue());
            addr = new StringRefAddr(attrName, value);
            this.poolReference.add(addr);
        }
        initialContext.bind(DataSourceHelper.getDataSourceJNDIName((String)this.name), (Object)this.poolReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindSelf(InitialContext initialContext) throws NamingException {
        try {
            PooledDataSourceRegistry registry = (PooledDataSourceRegistry)Framework.getLocalService(PooledDataSourceRegistry.class);
            if (registry != null) {
                registry.clearPool(this.name);
            }
        }
        catch (Exception cause) {
            NamingException error = new NamingException("Cannot clear pooled datasource " + this.name);
            error.initCause(cause);
            throw error;
        }
        finally {
            try {
                if (this.xaReference != null) {
                    initialContext.unbind(DataSourceHelper.getDataSourceJNDIName((String)(this.name + "-xa")));
                }
            }
            finally {
                initialContext.unbind(DataSourceHelper.getDataSourceJNDIName((String)this.name));
            }
        }
    }

    public static class PoolFactory
    implements ObjectFactory {
        @Override
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
            return ((PooledDataSourceRegistry)Framework.getLocalService(PooledDataSourceRegistry.class)).getOrCreatePool(obj, name, nameCtx, env);
        }
    }
}

