/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.admin;

import org.nuxeo.ecm.core.management.api.AdministrativeStatus;
import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.GlobalAdministrativeStatusManager;
import org.nuxeo.ecm.platform.api.login.RestrictedLoginHelper;
import org.nuxeo.ecm.platform.web.common.admin.AdminStatusHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;

public class AdministrativeStatusListener
implements EventListener {
    public static final String ADM_MESSAGE_SERVICE = "org.nuxeo.ecm.administrator.message";
    protected static String localInstanceId;

    public boolean aboutToHandleEvent(Event event) {
        return false;
    }

    protected static String getLocalInstanceId() {
        if (localInstanceId == null) {
            GlobalAdministrativeStatusManager gasm = (GlobalAdministrativeStatusManager)Framework.getLocalService(GlobalAdministrativeStatusManager.class);
            localInstanceId = gasm.getLocalNuxeoInstanceIdentifier();
        }
        return localInstanceId;
    }

    public void handleEvent(Event event) {
        String eventId = event.getId();
        String instanceId = (String)event.getSource();
        String serviceId = (String)event.getData();
        if (!AdministrativeStatusListener.getLocalInstanceId().equals(instanceId)) {
            return;
        }
        AdministrativeStatusManager asm = (AdministrativeStatusManager)Framework.getLocalService(AdministrativeStatusManager.class);
        if (serviceId.equals("org.nuxeo.ecm.instance.availability")) {
            if (eventId.equals("serviceActivated")) {
                AdminStatusHelper.instanceInMaintenanceMode = false;
                RestrictedLoginHelper.setRestrictedModeActivated((boolean)false);
            }
            if (eventId.equals("servicePassivated")) {
                AdminStatusHelper.instanceInMaintenanceMode = true;
                RestrictedLoginHelper.setRestrictedModeActivated((boolean)true);
            }
            AdminStatusHelper.maintenanceMessage = asm.getStatus("org.nuxeo.ecm.instance.availability").getMessage();
        }
        if (serviceId.equals(ADM_MESSAGE_SERVICE)) {
            if (eventId.equals("serviceActivated")) {
                AdminStatusHelper.adminMessageActivated = true;
            }
            if (eventId.equals("servicePassivated")) {
                AdminStatusHelper.adminMessageActivated = false;
            }
            AdministrativeStatus status = asm.getStatus(ADM_MESSAGE_SERVICE);
            AdminStatusHelper.adminMessage = status.getMessage();
            AdminStatusHelper.adminMessageModificationDate = status.getModificationDate();
        }
    }
}

