/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.WrappedException;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandlerParameters;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.ErrorHandler;

public class DefaultNuxeoExceptionHandler
implements NuxeoExceptionHandler {
    private static final Log log = LogFactory.getLog(DefaultNuxeoExceptionHandler.class);
    protected NuxeoExceptionHandlerParameters parameters;

    @Override
    public void setParameters(NuxeoExceptionHandlerParameters parameters) {
        this.parameters = parameters;
    }

    protected void startHandlingException(HttpServletRequest request, HttpServletResponse response, Throwable t) throws ServletException {
        if (request.getAttribute("NuxeoExceptionHandlerMarker") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initial exception", t);
            }
        } else {
            throw new ServletException(t);
        }
        request.setAttribute("NuxeoExceptionHandlerMarker", (Object)true);
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
    }

    @Override
    public void handleException(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException, ServletException {
        this.startHandlingException(request, response, t);
        try {
            ErrorHandler handler = this.getHandler(t);
            Integer code = handler.getCode();
            boolean is404 = Integer.valueOf(404).equals(code);
            this.parameters.getListener().startHandling(t, request, response);
            Throwable unwrappedException = DefaultNuxeoExceptionHandler.unwrapException(t);
            StringWriter swriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(swriter);
            t.printStackTrace(pwriter);
            String stackTrace = swriter.getBuffer().toString();
            if (is404) {
                log.debug((Object)t.getMessage());
            } else {
                log.error((Object)stackTrace);
                this.parameters.getLogger().error((Object)stackTrace);
            }
            this.parameters.getListener().beforeSetErrorPageAttribute(unwrappedException, request, response);
            request.setAttribute("exception_message", (Object)unwrappedException.getLocalizedMessage());
            request.setAttribute("user_message", this.getUserMessage(handler.getMessage(), request.getLocale()));
            request.setAttribute("stackTrace", (Object)stackTrace);
            request.setAttribute("securityError", (Object)ExceptionHelper.isSecurityError(unwrappedException));
            request.setAttribute("messageBundle", (Object)ResourceBundle.getBundle(this.parameters.getBundleName(), request.getLocale(), Thread.currentThread().getContextClassLoader()));
            String dumpedRequest = this.parameters.getRequestDumper().getDump(request);
            if (!is404) {
                this.parameters.getLogger().error((Object)dumpedRequest);
            }
            request.setAttribute("request_dump", (Object)dumpedRequest);
            this.parameters.getListener().beforeForwardToErrorPage(unwrappedException, request, response);
            if (!response.isCommitted()) {
                String errorPage;
                RequestDispatcher requestDispatcher;
                if (code != null) {
                    response.setStatus(code.intValue());
                }
                if ((requestDispatcher = request.getRequestDispatcher(errorPage = (errorPage = handler.getPage()) == null ? this.parameters.getDefaultErrorPage() : errorPage)) != null) {
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    log.error((Object)("Cannot forward to error page, no RequestDispatcher found for errorPage=" + errorPage + " handler=" + handler));
                }
                FacesContext fContext = FacesContext.getCurrentInstance();
                if (fContext != null) {
                    fContext.responseComplete();
                } else {
                    log.error((Object)"Cannot set response complete: faces context is null");
                }
            } else {
                log.error((Object)"Cannot forward to error page: response is already committed");
            }
            this.parameters.getListener().afterDispatch(unwrappedException, request, response);
        }
        catch (Throwable newError) {
            throw new ServletException(newError);
        }
    }

    protected ErrorHandler getHandler(Throwable t) {
        Throwable throwable = DefaultNuxeoExceptionHandler.unwrapException(t);
        String className = null;
        if (throwable instanceof WrappedException) {
            WrappedException wrappedException = (WrappedException)throwable;
            className = wrappedException.getClassName();
        } else {
            className = throwable.getClass().getName();
        }
        for (ErrorHandler handler : this.parameters.getHandlers()) {
            if (handler.getError() == null || !className.matches(handler.getError())) continue;
            return handler;
        }
        throw new ClientRuntimeException("No error handler set.");
    }

    protected Object getUserMessage(String messageKey, Locale locale) {
        return I18NUtils.getMessageString((String)this.parameters.getBundleName(), (String)messageKey, null, (Locale)locale);
    }

    @Deprecated
    public static Throwable unwrapException(Throwable t) {
        return ExceptionHelper.unwrapException(t);
    }
}

