/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.FilterConfigDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.LRUCachingMap;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoCorsFilterDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoCorsFilterDescriptorRegistry;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestControllerManager;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestFilterConfig;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestFilterConfigImpl;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class RequestControllerService
extends DefaultComponent
implements RequestControllerManager {
    public static final String FILTER_CONFIG_EP = "filterConfig";
    public static final String CORS_CONFIG_EP = "corsConfig";
    private static final Log log = LogFactory.getLog(RequestControllerService.class);
    protected static final Map<String, FilterConfigDescriptor> grantPatterns = new LinkedHashMap<String, FilterConfigDescriptor>();
    protected static final Map<String, FilterConfigDescriptor> denyPatterns = new LinkedHashMap<String, FilterConfigDescriptor>();
    protected static final Map<String, RequestFilterConfig> configCache = new LRUCachingMap<String, RequestFilterConfig>(250);
    protected static final Map<String, FilterConfig> filterConfigCache = new LRUCachingMap<String, FilterConfig>(250);
    protected static final NuxeoCorsFilterDescriptorRegistry corsFilterRegistry = new NuxeoCorsFilterDescriptorRegistry();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (FILTER_CONFIG_EP.equals(extensionPoint)) {
            FilterConfigDescriptor desc = (FilterConfigDescriptor)contribution;
            this.registerFilterConfig(desc);
        } else if (CORS_CONFIG_EP.equals(extensionPoint)) {
            corsFilterRegistry.addContribution((NuxeoCorsFilterDescriptor)contribution);
        } else {
            log.error((Object)("Unknown ExtensionPoint " + extensionPoint));
        }
    }

    public void registerFilterConfig(String name, String pattern, boolean grant, boolean tx, boolean sync, boolean cached, boolean isPrivate, String cacheTime) {
        FilterConfigDescriptor desc = new FilterConfigDescriptor(name, pattern, grant, tx, sync, cached, isPrivate, cacheTime);
        this.registerFilterConfig(desc);
    }

    public void registerFilterConfig(FilterConfigDescriptor desc) {
        if (desc.isGrantRule()) {
            grantPatterns.put(desc.getName(), desc);
            log.debug((Object)"Registered grant filter config");
        } else {
            denyPatterns.put(desc.getName(), desc);
            log.debug((Object)"Registered deny filter config");
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CORS_CONFIG_EP.equals(extensionPoint)) {
            corsFilterRegistry.removeContribution((NuxeoCorsFilterDescriptor)contribution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterConfig getCorsConfigForRequest(HttpServletRequest request) {
        String uri = request.getRequestURI();
        FilterConfig filterConfig = null;
        Map<String, FilterConfig> map = filterConfigCache;
        synchronized (map) {
            filterConfig = filterConfigCache.get(uri);
        }
        if (filterConfig == null) {
            filterConfig = this.computeCorsFilterConfigForUri(uri);
            map = filterConfigCache;
            synchronized (map) {
                filterConfigCache.put(uri, filterConfig);
            }
        }
        return filterConfig;
    }

    public FilterConfig computeCorsFilterConfigForUri(String uri) {
        NuxeoCorsFilterDescriptor descriptor = corsFilterRegistry.getFirstMatchingDescriptor(uri);
        return descriptor != null ? descriptor.buildFilterConfig() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestFilterConfig getConfigForRequest(HttpServletRequest request) {
        String uri = request.getRequestURI();
        RequestFilterConfig config = null;
        Map<String, RequestFilterConfig> map = configCache;
        synchronized (map) {
            config = configCache.get(uri);
        }
        if (config == null) {
            config = this.computeConfigForRequest(uri);
            map = configCache;
            synchronized (map) {
                configCache.put(uri, config);
            }
        }
        return config;
    }

    public RequestFilterConfig computeConfigForRequest(String uri) {
        Matcher m;
        Pattern pat;
        for (FilterConfigDescriptor desc : denyPatterns.values()) {
            pat = desc.getCompiledPattern();
            m = pat.matcher(uri);
            if (!m.matches()) continue;
            return new RequestFilterConfigImpl(false, false, false, false, false, "");
        }
        for (FilterConfigDescriptor desc : grantPatterns.values()) {
            pat = desc.getCompiledPattern();
            m = pat.matcher(uri);
            if (!m.matches()) continue;
            return new RequestFilterConfigImpl(desc.useSync(), desc.useTx(), desc.useTxBuffered(), desc.isCached(), desc.isPrivate(), desc.getCacheTime());
        }
        return new RequestFilterConfigImpl(false, false, false, false, false, "");
    }
}

