/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.message.ServerSearchResult;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthorizationService.class);
    private static LdapDN USER_BASE_DN;
    private static LdapDN GROUP_BASE_DN;
    private static LdapDN ADMIN_GROUP_DN;
    private boolean enabled = true;
    private Set<String> administrators = new HashSet<String>(2);
    private Map<String, OidNormalizer> normalizerMapping;
    private PartitionNexus nexus;
    private AttributeTypeRegistry attrRegistry;
    private AttributeType uniqueMemberAT;

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        this.nexus = factoryCfg.getPartitionNexus();
        this.normalizerMapping = factoryCfg.getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.enabled = !factoryCfg.getStartupConfiguration().isAccessControlEnabled();
        USER_BASE_DN = PartitionNexus.getUsersBaseName();
        USER_BASE_DN.normalize(this.normalizerMapping);
        GROUP_BASE_DN = PartitionNexus.getGroupsBaseName();
        GROUP_BASE_DN.normalize(this.normalizerMapping);
        ADMIN_GROUP_DN = new LdapDN("cn=Administrators,ou=groups,ou=system");
        ADMIN_GROUP_DN.normalize(this.normalizerMapping);
        this.attrRegistry = factoryCfg.getRegistries().getAttributeTypeRegistry();
        this.uniqueMemberAT = this.attrRegistry.lookup("2.5.4.50");
        this.loadAdministrators();
    }

    private void loadAdministrators() throws NamingException {
        HashSet<String> newAdministrators = new HashSet<String>(2);
        Attributes adminGroup = this.nexus.lookup(new LookupOperationContext(ADMIN_GROUP_DN));
        if (adminGroup == null) {
            return;
        }
        Attribute uniqueMember = AttributeUtils.getAttribute((Attributes)adminGroup, (AttributeType)this.uniqueMemberAT);
        for (int ii = 0; ii < uniqueMember.size(); ++ii) {
            LdapDN memberDn = new LdapDN((String)uniqueMember.get(ii));
            memberDn.normalize(this.normalizerMapping);
            newAdministrators.add(memberDn.getNormName());
        }
        this.administrators = newAdministrators;
    }

    @Override
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        if (!this.enabled) {
            nextInterceptor.delete(opContext);
            return;
        }
        LdapDN principalDn = DefaultAuthorizationService.getPrincipal().getJndiName();
        if (name.isEmpty()) {
            String msg = "The rootDSE cannot be deleted!";
            log.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (name.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
            String msg = "The Administrators group cannot be deleted!";
            log.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(name)) {
            String msg = "User " + principalDn.getUpName();
            msg = msg + " does not have permission to delete the admin account.";
            msg = msg + " No one not even the admin can delete this account!";
            log.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (name.size() > 2 && !this.isAnAdministrator(principalDn)) {
            if (name.startsWith((Name)USER_BASE_DN)) {
                String msg = "User " + principalDn.getUpName();
                msg = msg + " does not have permission to delete the user account: ";
                msg = msg + name.getUpName() + ". Only the admin can delete user accounts.";
                log.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (name.startsWith((Name)GROUP_BASE_DN)) {
                String msg = "User " + principalDn.getUpName();
                msg = msg + " does not have permission to delete the group entry: ";
                msg = msg + name.getUpName() + ". Only the admin can delete groups.";
                log.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
        nextInterceptor.delete(opContext);
    }

    private final boolean isTheAdministrator(LdapDN normalizedDn) {
        return normalizedDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    private final boolean isAnAdministrator(LdapDN normalizedDn) {
        if (this.isTheAdministrator(normalizedDn)) {
            return true;
        }
        return this.administrators.contains(normalizedDn.getNormName());
    }

    @Override
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws NamingException {
        if (this.enabled) {
            LdapDN dn = opContext.getDn();
            this.protectModifyAlterations(dn);
            nextInterceptor.modify(opContext);
            if (dn.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
                this.loadAdministrators();
            }
        } else {
            nextInterceptor.modify(opContext);
        }
    }

    private void protectModifyAlterations(LdapDN dn) throws NamingException {
        LdapDN principalDn = DefaultAuthorizationService.getPrincipal().getJndiName();
        if (dn.isEmpty()) {
            String msg = "The rootDSE cannot be modified!";
            log.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (!this.isAnAdministrator(principalDn)) {
            if (dn.getNormName().equals(DefaultAuthorizationService.getPrincipal().getJndiName().getNormName())) {
                return;
            }
            if (dn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
                String msg = "User " + principalDn.getUpName();
                msg = msg + " does not have permission to modify the account of the";
                msg = msg + " admin user.";
                log.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2) {
                if (dn.startsWith((Name)USER_BASE_DN)) {
                    String msg = "User " + principalDn.getUpName();
                    msg = msg + " does not have permission to modify the account of the";
                    msg = msg + " user " + dn.getUpName() + ".\nEven the owner of an account cannot";
                    msg = msg + " modify it.\nUser accounts can only be modified by the";
                    msg = msg + " administrator.";
                    log.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (dn.startsWith((Name)GROUP_BASE_DN)) {
                    String msg = "User " + principalDn.getUpName();
                    msg = msg + " does not have permission to modify the group entry ";
                    msg = msg + dn.getUpName() + ".\nGroups can only be modified by the admin.";
                    log.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
        }
    }

    @Override
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws NamingException {
        if (this.enabled) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.rename(opContext);
    }

    @Override
    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws NamingException {
        if (this.enabled) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.move(opContext);
    }

    @Override
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws NamingException {
        if (this.enabled) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.moveAndRename(opContext);
    }

    private void protectDnAlterations(LdapDN dn) throws NamingException {
        LdapDN principalDn = DefaultAuthorizationService.getPrincipal().getJndiName();
        if (dn.isEmpty()) {
            String msg = "The rootDSE cannot be moved or renamed!";
            log.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
            String msg = "The Administrators group cannot be moved or renamed!";
            log.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(dn)) {
            String msg = "User '" + principalDn.getUpName();
            msg = msg + "' does not have permission to move or rename the admin";
            msg = msg + " account.  No one not even the admin can move or";
            msg = msg + " rename " + dn.getUpName() + "!";
            log.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith((Name)USER_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = "User '" + principalDn.getUpName();
            msg = msg + "' does not have permission to move or rename the user";
            msg = msg + " account: " + dn.getUpName() + ". Only the admin can move or";
            msg = msg + " rename user accounts.";
            log.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith((Name)GROUP_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = "User " + principalDn.getUpName();
            msg = msg + " does not have permission to move or rename the group entry ";
            msg = msg + dn.getUpName() + ".\nGroups can only be moved or renamed by the admin.";
            throw new LdapNoPermissionException(msg);
        }
    }

    @Override
    public Attributes lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws NamingException {
        Attributes attributes = nextInterceptor.lookup(opContext);
        if (!this.enabled || attributes == null) {
            return attributes;
        }
        this.protectLookUp(opContext.getDn());
        return attributes;
    }

    private void protectLookUp(LdapDN normalizedDn) throws NamingException {
        LdapContext ctx = (LdapContext)InvocationStack.getInstance().peek().getCaller();
        LdapDN principalDn = ((ServerContext)((Object)ctx)).getPrincipal().getJndiName();
        if (!this.isAnAdministrator(principalDn)) {
            if (normalizedDn.size() > 2) {
                if (normalizedDn.startsWith((Name)USER_BASE_DN)) {
                    if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                        return;
                    }
                    String msg = "Access to user account '" + normalizedDn.getUpName() + "' not permitted";
                    msg = msg + " for user '" + principalDn.getUpName() + "'.  Only the admin can";
                    msg = msg + " access user account information";
                    log.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (normalizedDn.startsWith((Name)GROUP_BASE_DN)) {
                    if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                        return;
                    }
                    String msg = "Access to group '" + normalizedDn.getUpName() + "' not permitted";
                    msg = msg + " for user '" + principalDn.getUpName() + "'.  Only the admin can";
                    msg = msg + " access group information";
                    log.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
            if (this.isTheAdministrator(normalizedDn)) {
                if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                    return;
                }
                String msg = "Access to admin account not permitted for user '";
                msg = msg + principalDn.getUpName() + "'.  Only the admin can";
                msg = msg + " access admin account information";
                log.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws NamingException {
        NamingEnumeration<SearchResult> e = nextInterceptor.search(opContext);
        if (!this.enabled) {
            return e;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, opContext.getSearchControls(), invocation, new SearchResultFilter(){

            public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
                return DefaultAuthorizationService.this.isSearchable(invocation, result);
            }
        }, "Search Default Authorization filter");
    }

    @Override
    public NamingEnumeration<SearchResult> list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws NamingException {
        NamingEnumeration<SearchResult> e = nextInterceptor.list(opContext);
        if (!this.enabled) {
            return e;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, null, invocation, new SearchResultFilter(){

            public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
                return DefaultAuthorizationService.this.isSearchable(invocation, result);
            }
        }, "List Default Authorization filter");
    }

    private boolean isSearchable(Invocation invocation, SearchResult result) throws NamingException {
        LdapDN principalDn = ((ServerContext)invocation.getCaller()).getPrincipal().getJndiName();
        LdapDN dn = ((ServerSearchResult)result).getDn();
        if (!dn.isNormalized()) {
            dn.normalize(this.normalizerMapping);
        }
        if (this.isAnAdministrator(principalDn)) {
            return true;
        }
        boolean isSelfRead = dn.getNormName().equals(principalDn.getNormName());
        if (isSelfRead) {
            return true;
        }
        if (dn.size() > 2 && (dn.getNormName().endsWith(USER_BASE_DN.getNormName()) || dn.getNormName().endsWith(GROUP_BASE_DN.getNormName()))) {
            return false;
        }
        return !this.isTheAdministrator(dn);
    }
}

