/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxValueCountFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(Collection<ACITuple> tuples, OperationScope scope, PartitionNexusProxy proxy, Collection<LdapDN> userGroupNames, LdapDN userName, Attributes userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Attributes entry, Collection<MicroOperation> microOperations) throws NamingException {
        if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) {
            return tuples;
        }
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator<ACITuple> i = tuples.iterator();
        block0: while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (!tuple.isGrant()) continue;
            for (ProtectedItem item : tuple.getProtectedItems()) {
                ProtectedItem.MaxValueCount mvc;
                if (!(item instanceof ProtectedItem.MaxValueCount) || !this.isRemovable(mvc = (ProtectedItem.MaxValueCount)item, attrId, entry)) continue;
                i.remove();
                continue block0;
            }
        }
        return tuples;
    }

    private boolean isRemovable(ProtectedItem.MaxValueCount mvc, String attrId, Attributes entry) {
        for (ProtectedItem.MaxValueCountItem mvcItem : mvc) {
            Attribute attr;
            int attrCount;
            if (!attrId.equalsIgnoreCase(mvcItem.getAttributeType()) || (attrCount = (attr = entry.get(attrId)) == null ? 0 : attr.size()) < mvcItem.getMaxCount()) continue;
            return true;
        }
        return false;
    }
}

