/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.kerberos;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyDerivationService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(KeyDerivationService.class);
    public static final String NAME = "keyDerivationService";
    private static final Collection<String> USERLOOKUP_BYPASS;

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws NamingException {
        LdapDN normName = addContext.getDn();
        Attributes entry = addContext.getEntry();
        if (entry.get("userPassword") != null && entry.get("krb5PrincipalName") != null) {
            log.debug("Adding the entry '{}' for DN '{}'.", (Object)AttributeUtils.toString((Attributes)entry), (Object)normName.getUpName());
            Object firstValue = entry.get("userPassword").get();
            if (firstValue instanceof String) {
                log.debug("Adding Attribute id : 'userPassword',  Values : [ '{}' ]", firstValue);
            } else if (firstValue instanceof byte[]) {
                String string = StringTools.utf8ToString((byte[])((byte[])firstValue));
                if (log.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("'" + string + "' ( ");
                    sb.append(StringTools.dumpBytes((byte[])((byte[])firstValue)).trim());
                    sb.append(" )");
                    log.debug("Adding Attribute id : 'userPassword',  Values : [ {} ]", (Object)sb.toString());
                }
                firstValue = string;
            }
            String userPassword = (String)firstValue;
            String principalName = (String)entry.get("krb5PrincipalName").get();
            log.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)userPassword);
            Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, userPassword);
            entry.put("krb5PrincipalName", principalName);
            entry.put("krb5KeyVersionNumber", Integer.toString(0));
            entry.put(this.getKeyAttribute(keys));
            log.debug("Adding modified entry '{}' for DN '{}'.", (Object)AttributeUtils.toString((Attributes)entry), (Object)normName.getUpName());
        }
        next.add(addContext);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modContext) throws NamingException {
        ModifySubContext subContext = new ModifySubContext();
        this.detectPasswordModification(modContext, subContext);
        if (subContext.getUserPassword() != null) {
            this.lookupPrincipalAttributes(modContext, subContext);
        }
        if (subContext.isPrincipal() && subContext.hasValues()) {
            this.deriveKeys(modContext, subContext);
        }
        next.modify(modContext);
    }

    void detectPasswordModification(ModifyOperationContext modContext, ModifySubContext subContext) throws NamingException {
        ModificationItemImpl[] mods = modContext.getModItems();
        String operation = null;
        for (int ii = 0; ii < mods.length; ++ii) {
            Attribute attr;
            String attrId;
            if (log.isDebugEnabled()) {
                switch (mods[ii].getModificationOp()) {
                    case 1: {
                        operation = "Adding";
                        break;
                    }
                    case 3: {
                        operation = "Removing";
                        break;
                    }
                    case 2: {
                        operation = "Replacing";
                    }
                }
            }
            if ((attrId = (attr = mods[ii].getAttribute()).getID()).equalsIgnoreCase("userPassword")) {
                Object firstValue = attr.get();
                if (firstValue instanceof String) {
                    log.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, firstValue);
                } else if (firstValue instanceof byte[]) {
                    String string = StringTools.utf8ToString((byte[])((byte[])firstValue));
                    if (log.isDebugEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("'" + string + "' ( ");
                        sb.append(StringTools.dumpBytes((byte[])((byte[])firstValue)).trim());
                        sb.append(" )");
                        log.debug("{} Attribute id : 'userPassword',  Values : [ {} ]", (Object)operation, (Object)sb.toString());
                    }
                    firstValue = string;
                }
                subContext.setUserPassword((String)firstValue);
                log.debug("Got userPassword '{}'.", (Object)subContext.getUserPassword());
            }
            if (!attrId.equalsIgnoreCase("krb5PrincipalName")) continue;
            subContext.setPrincipalName((String)attr.get());
            log.debug("Got principal '{}'.", (Object)subContext.getPrincipalName());
        }
    }

    void lookupPrincipalAttributes(ModifyOperationContext modContext, ModifySubContext subContext) throws NamingException {
        Attribute keyVersionNumberAttr;
        LdapDN principalDn = modContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        LookupOperationContext lookupContext = new LookupOperationContext(new String[]{"objectClass", "krb5PrincipalName", "krb5KeyVersionNumber"});
        lookupContext.setDn(principalDn);
        Attributes userEntry = proxy.lookup(lookupContext, USERLOOKUP_BYPASS);
        if (userEntry == null) {
            throw new LdapAuthenticationException("Failed to authenticate user '" + principalDn + "'.");
        }
        Attribute objectClass = userEntry.get("objectClass");
        if (!AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"krb5Principal")) {
            return;
        }
        subContext.isPrincipal(true);
        log.debug("DN {} is a Kerberos principal.  Will attempt key derivation.", (Object)principalDn.getUpName());
        if (subContext.getPrincipalName() == null) {
            Attribute principalAttribute = userEntry.get("krb5PrincipalName");
            String principalName = (String)principalAttribute.get();
            subContext.setPrincipalName(principalName);
            log.debug("Found principal '{}' from lookup.", (Object)principalName);
        }
        if ((keyVersionNumberAttr = userEntry.get("krb5KeyVersionNumber")) == null) {
            subContext.setNewKeyVersionNumber(0);
            log.debug("Key version number was null, setting to 0.");
        } else {
            int oldKeyVersionNumber = Integer.valueOf((String)keyVersionNumberAttr.get());
            int newKeyVersionNumber = oldKeyVersionNumber + 1;
            subContext.setNewKeyVersionNumber(newKeyVersionNumber);
            log.debug("Found key version number '{}', setting to '{}'.", (Object)oldKeyVersionNumber, (Object)newKeyVersionNumber);
        }
    }

    void deriveKeys(ModifyOperationContext modContext, ModifySubContext subContext) {
        ModificationItemImpl[] mods = modContext.getModItems();
        String principalName = subContext.getPrincipalName();
        String userPassword = subContext.getUserPassword();
        int kvno = subContext.getNewKeyVersionNumber();
        log.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)userPassword);
        Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, userPassword);
        HashSet<ModificationItemImpl> newModsList = new HashSet<ModificationItemImpl>();
        for (int ii = 0; ii < mods.length; ++ii) {
            newModsList.add(mods[ii]);
        }
        newModsList.add(new ModificationItemImpl(2, (Attribute)new AttributeImpl("krb5PrincipalName", (Object)principalName)));
        newModsList.add(new ModificationItemImpl(2, (Attribute)new AttributeImpl("krb5KeyVersionNumber", (Object)Integer.toString(kvno))));
        newModsList.add(new ModificationItemImpl(2, this.getKeyAttribute(keys)));
        ModificationItemImpl[] newMods = newModsList.toArray(mods);
        modContext.setModItems(newMods);
    }

    private Attribute getKeyAttribute(Map<EncryptionType, EncryptionKey> keys) {
        AttributeImpl keyAttribute = new AttributeImpl("krb5Key");
        Iterator<EncryptionKey> it = keys.values().iterator();
        while (it.hasNext()) {
            try {
                keyAttribute.add(EncryptionKeyEncoder.encode((EncryptionKey)it.next()));
            }
            catch (IOException ioe) {
                log.error("Error encoding EncryptionKey.", (Throwable)ioe);
            }
        }
        return keyAttribute;
    }

    private Map<EncryptionType, EncryptionKey> generateKeys(String principalName, String userPassword) {
        if (userPassword.equalsIgnoreCase("randomKey")) {
            try {
                return RandomKeyFactory.getRandomKeys();
            }
            catch (KerberosException ke) {
                log.debug(ke.getMessage(), (Throwable)ke);
                return null;
            }
        }
        return KerberosKeyFactory.getKerberosKeys((String)principalName, (String)userPassword);
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("referralService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("exceptionService");
        c.add("operationalAttributeService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("collectiveAttributeService");
        c.add("eventService");
        c.add("triggerService");
        USERLOOKUP_BYPASS = Collections.unmodifiableCollection(c);
    }

    class ModifySubContext {
        private boolean isPrincipal = false;
        private String principalName;
        private String userPassword;
        private int newKeyVersionNumber = -1;

        ModifySubContext() {
        }

        boolean isPrincipal() {
            return this.isPrincipal;
        }

        void isPrincipal(boolean isPrincipal) {
            this.isPrincipal = isPrincipal;
        }

        String getPrincipalName() {
            return this.principalName;
        }

        void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        String getUserPassword() {
            return this.userPassword;
        }

        void setUserPassword(String userPassword) {
            this.userPassword = userPassword;
        }

        int getNewKeyVersionNumber() {
            return this.newKeyVersionNumber;
        }

        void setNewKeyVersionNumber(int newKeyVersionNumber) {
            this.newKeyVersionNumber = newKeyVersionNumber;
        }

        boolean hasValues() {
            return this.userPassword != null && this.principalName != null && this.newKeyVersionNumber > -1;
        }
    }
}

