/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.Optimizer;
import org.apache.directory.shared.ldap.filter.AssertionNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;

public class DefaultOptimizer
implements Optimizer {
    private static final Long MAX = Long.MAX_VALUE;
    private BTreePartition db;

    public DefaultOptimizer(BTreePartition db) {
        this.db = db;
    }

    public void annotate(ExprNode node) throws NamingException {
        Long count = MAX;
        if (node instanceof ScopeNode) {
            count = this.getScopeScan((ScopeNode)node);
        } else if (!(node instanceof AssertionNode)) {
            if (node.isLeaf()) {
                LeafNode leaf = (LeafNode)node;
                switch (leaf.getAssertionType()) {
                    case APPROXIMATE: {
                        count = this.getEqualityScan((SimpleNode)leaf);
                        break;
                    }
                    case EQUALITY: {
                        count = this.getEqualityScan((SimpleNode)leaf);
                        break;
                    }
                    case EXTENSIBLE: {
                        count = this.getFullScan(leaf);
                        break;
                    }
                    case GREATEREQ: {
                        count = this.getGreaterLessScan((SimpleNode)leaf, true);
                        break;
                    }
                    case LESSEQ: {
                        count = this.getGreaterLessScan((SimpleNode)leaf, false);
                        break;
                    }
                    case PRESENCE: {
                        count = this.getPresenceScan((PresenceNode)leaf);
                        break;
                    }
                    case SUBSTRING: {
                        count = this.getFullScan(leaf);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized leaf node");
                    }
                }
            } else {
                BranchNode bnode = (BranchNode)node;
                switch (bnode.getOperator()) {
                    case AND: {
                        count = this.getConjunctionScan(bnode);
                        break;
                    }
                    case NOT: {
                        count = this.getNegationScan(bnode);
                        break;
                    }
                    case OR: {
                        count = this.getDisjunctionScan(bnode);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized branch node type");
                    }
                }
            }
        }
        if (count.compareTo(0L) < 0) {
            count = MAX;
        }
        node.set("count", (Object)count);
    }

    private Long getConjunctionScan(BranchNode node) throws NamingException {
        Long count = MAX;
        List children = node.getChildren();
        for (int ii = 0; ii < children.size(); ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            this.annotate(child);
            count = Math.min((Long)child.get((Object)"count"), count);
        }
        return count;
    }

    private Long getNegationScan(BranchNode node) throws NamingException {
        return MAX;
    }

    private Long getDisjunctionScan(BranchNode node) throws NamingException {
        List children = node.getChildren();
        Long total = 0L;
        for (int ii = 0; ii < children.size(); ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            this.annotate(child);
            total = total + (Long)child.get((Object)"count");
        }
        if (total.compareTo(MAX) > 0) {
            total = MAX;
        }
        return total;
    }

    private Long getEqualityScan(SimpleNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return idx.count(node.getValue());
        }
        return MAX;
    }

    private Long getGreaterLessScan(SimpleNode node, boolean isGreaterThan) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            int count = idx.count(node.getValue(), isGreaterThan);
            return count;
        }
        return MAX;
    }

    private Long getFullScan(LeafNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            int count = idx.count();
            return count;
        }
        return MAX;
    }

    private Long getPresenceScan(PresenceNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getExistanceIndex();
            int count = idx.count((Object)node.getAttribute());
            return count;
        }
        return MAX;
    }

    private Long getScopeScan(ScopeNode node) throws NamingException {
        switch (node.getScope()) {
            case 0: {
                return 1L;
            }
            case 1: {
                Long id = this.db.getEntryId(node.getBaseDn());
                return this.db.getChildCount(id);
            }
            case 2: {
                return this.db.count();
            }
        }
        throw new IllegalArgumentException("Unrecognized search scope value for filter scope node");
    }
}

