/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.DisjunctionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.Enumerator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.ScopeEvaluator;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.util.SingletonEnumeration;

public class ScopeEnumerator
implements Enumerator {
    private BTreePartition db = null;
    private ScopeEvaluator evaluator = null;

    public ScopeEnumerator(BTreePartition db, ScopeEvaluator evaluator) {
        this.db = db;
        this.evaluator = evaluator;
    }

    public NamingEnumeration enumerate(ExprNode node) throws NamingException {
        ScopeNode snode = (ScopeNode)node;
        Long id = this.db.getEntryId(snode.getBaseDn());
        switch (snode.getScope()) {
            case 0: {
                IndexRecord record = new IndexRecord();
                record.setEntryId((Object)id);
                record.setIndexKey((Object)snode.getBaseDn());
                return new SingletonEnumeration((Object)record);
            }
            case 1: {
                return this.enumerateChildren(snode.getBaseDn(), snode.getDerefAliases().isDerefInSearching());
            }
            case 2: {
                return this.enumerateDescendants(snode);
            }
        }
        throw new NamingException("Unrecognized search scope!");
    }

    private NamingEnumeration enumerateChildren(String dn, boolean deref) throws NamingException {
        Index idx = this.db.getHierarchyIndex();
        Long id = this.db.getEntryId(dn);
        IndexEnumeration children = idx.listIndices((Object)id);
        if (!deref) {
            return children;
        }
        idx = this.db.getOneAliasIndex();
        IndexEnumeration aliasIntroduced = idx.listIndices((Object)id);
        IndexAssertionEnumeration nonAliasChildren = new IndexAssertionEnumeration((NamingEnumeration)children, (IndexAssertion)new AssertNotAlias());
        NamingEnumeration[] all = new NamingEnumeration[]{nonAliasChildren, aliasIntroduced};
        return new DisjunctionEnumeration(all);
    }

    private NamingEnumeration enumerateDescendants(final ScopeNode node) throws NamingException {
        Index idx = null;
        if (!node.getDerefAliases().isDerefInSearching()) {
            idx = this.db.getNdnIndex();
            IndexEnumeration underlying = idx.listIndices();
            return new IndexAssertionEnumeration((NamingEnumeration)underlying, (IndexAssertion)new AssertDescendant(node));
        }
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                return ScopeEnumerator.this.evaluator.evaluate((ExprNode)node, rec);
            }
        };
        idx = this.db.getNdnIndex();
        IndexEnumeration underlying = idx.listIndices();
        return new IndexAssertionEnumeration((NamingEnumeration)underlying, assertion);
    }

    class AssertNotAlias
    implements IndexAssertion {
        AssertNotAlias() {
        }

        public boolean assertCandidate(IndexRecord record) throws NamingException {
            Index aliasIdx = ScopeEnumerator.this.db.getAliasIndex();
            return null == aliasIdx.reverseLookup(record.getEntryId());
        }
    }

    class AssertDescendant
    implements IndexAssertion {
        private final ScopeNode scope;

        AssertDescendant(ScopeNode node) {
            this.scope = node;
        }

        public boolean assertCandidate(IndexRecord record) throws NamingException {
            String dn = ScopeEnumerator.this.db.getEntryDn((Long)record.getEntryId());
            return dn.endsWith(this.scope.getBaseDn());
        }
    }
}

