/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.json;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;

public class DocumentModelToJSON
implements PropertyVisitor {
    Log log = LogFactory.getLog(DocumentModelToJSON.class);
    protected static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
    protected JSONObject result;

    public JSONObject getResult() {
        return this.result;
    }

    public JSONObject run(DocumentModel doc) throws ClientException {
        this.result = new JSONObject();
        doc.accept((PropertyVisitor)this, (Object)this.result);
        return this.result;
    }

    public boolean acceptPhantoms() {
        return false;
    }

    public Object visit(MapProperty property, Object arg) throws PropertyException {
        Serializable value = null;
        value = property.isContainer() ? new JSONObject() : property.getValue();
        if (property instanceof BlobProperty) {
            this.log.warn((Object)("Property '" + property.getName() + "' ignored during serialization. Blob and blob related properties are not written to json object."));
        } else if (property.getParent() instanceof BlobProperty) {
            this.log.warn((Object)("Property '" + property.getName() + "' ignored during serialization. Blob and blob related properties are not written to json object."));
        } else if (property.getParent().isList()) {
            ((JSONArray)arg).add((Object)value);
        } else {
            try {
                ((JSONObject)arg).put((Object)property.getField().getName().getPrefixedName(), (Object)value);
            }
            catch (JSONException e) {
                throw new PropertyException("Failed to put value", (Throwable)e);
            }
        }
        return value;
    }

    public Object visit(ListProperty property, Object arg) throws PropertyException {
        Serializable value = null;
        value = property.isContainer() ? new JSONArray() : property.getValue();
        if (property.getParent() instanceof BlobProperty) {
            this.log.warn((Object)("Property '" + property.getName() + "' ignored during serialization. Blob and blob related properties are not written to json object."));
        } else if (property.getParent().isList()) {
            ((JSONArray)arg).add((Object)value);
        } else {
            try {
                ((JSONObject)arg).put((Object)property.getField().getName().getPrefixedName(), (Object)value);
            }
            catch (JSONException e) {
                throw new PropertyException("Failed to put value", (Throwable)e);
            }
        }
        return value;
    }

    public Object visit(ScalarProperty property, Object arg) throws PropertyException {
        if (property.getParent() instanceof BlobProperty) {
            this.log.warn((Object)("Property '" + property.getName() + "' ignored during serialization. Blob and blob related properties are not written to json object."));
            return null;
        }
        Object value = property.getValue();
        if (value instanceof Calendar) {
            value = dateFormat.format(((Calendar)value).getTime());
        }
        if (property.getParent().isList()) {
            ((JSONArray)arg).add(value);
        } else {
            try {
                ((JSONObject)arg).put((Object)property.getField().getName().getPrefixedName(), value);
            }
            catch (JSONException e) {
                throw new PropertyException("Failed to put value", (Throwable)e);
            }
        }
        return null;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

