/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.web.resources.api.Resource;

@XObject(value="resource")
public class ResourceDescriptor
implements Resource {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    public String name;
    @XNode(value="@type")
    public String type;
    @XNode(value="@target")
    public String target;
    @XNode(value="path")
    public String path;
    @XNodeList(value="require", type=ArrayList.class, componentType=String.class)
    public List<String> dependencies;
    @XNodeList(value="processors/processor", type=ArrayList.class, componentType=String.class)
    public List<String> processors;
    @XNode(value="shrinkable")
    public boolean shrinkable = true;
    @XNode(value="uri")
    protected String uri;

    public String getName() {
        return this.name;
    }

    public String getType() {
        if (StringUtils.isBlank((String)this.type)) {
            return FileUtils.getFileExtension((String)this.name);
        }
        return this.type;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<String> getProcessors() {
        return this.processors;
    }

    public String getPath() {
        return this.path;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isShrinkable() {
        return this.shrinkable;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public void setProcessors(List<String> processors) {
        this.processors = processors;
    }

    public void setShrinkable(boolean shrinkable) {
        this.shrinkable = shrinkable;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

